<?php
/**
 * Admin Dashboard Template
 */
if (!defined('ABSPATH')) exit;

$core = WPSH_Core::get_instance();
$enabled = get_option('wpsh_enabled', '0') === '1';
$license_active = wpsh_is_license_active();
$effective_enabled = $enabled && $license_active;

// Calculate Stats (post/page always included, attachment always excluded)
$public_types = get_post_types(['public' => true]);
$excluded_pts = $core->get_effective_excluded_post_types();
$target_pts = array_diff($public_types, $excluded_pts);

$total_reachable = 0;
foreach ($target_pts as $pt) {
    $total_reachable += intval(wp_count_posts($pt)->publish);
}

// Add special URLs to reachable
$special_urls = [home_url('/')];
$posts_page_id = get_option('page_for_posts');
if ($posts_page_id) $special_urls[] = get_permalink($posts_page_id);
$total_reachable += count(array_unique($special_urls));

// Add taxonomies (all excluded by default when option empty)
$public_taxes = get_taxonomies(['public' => true]);
$excluded_taxes = $core->get_effective_excluded_taxonomies();
$target_taxes = array_diff($public_taxes, $excluded_taxes);
foreach ($target_taxes as $tax) {
    $total_reachable += intval(wp_count_terms(['taxonomy' => $tax, 'hide_empty' => false]));
}

$static_dir = $core->get_storage_dir();
$cached_count = 0;
if (file_exists($static_dir)) {
    $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($static_dir));
    foreach ($it as $file) {
        if ($file->getFilename() === 'index.html') $cached_count++;
    }
}
?>

<div class="wpsh-wrapper" data-wpsh-enabled="<?php echo $effective_enabled ? '1' : '0'; ?>" data-wpsh-license-active="<?php echo $license_active ? '1' : '0'; ?>">
    <!-- Header -->
    <div class="wpsh-header">
        <div class="wpsh-brand">
            <span class="wpsh-logo"><span class="dashicons dashicons-html"></span></span>
            <h1>WP Static</h1>
        </div>
        <div class="wpsh-header-actions">
            <div class="wpsh-master-status <?php echo $effective_enabled ? 'enabled' : 'disabled'; ?>">
                <span class="status-label"><?php
                    if (!$license_active) {
                        esc_html_e('Activate license to enable', 'wp-static-html-pages');
                    } else {
                        echo $enabled ? esc_html__('Plugin Enabled', 'wp-static-html-pages') : esc_html__('Plugin Disabled', 'wp-static-html-pages');
                    }
                ?></span>
                <label class="wpsh-switch" title="<?php echo !$license_active ? esc_attr__('Activate your license in the Licence tab first.', 'wp-static-html-pages') : ''; ?>">
                    <input type="checkbox" id="wpsh-master-toggle" <?php checked($enabled); ?> <?php echo !$license_active ? ' disabled' : ''; ?>>
                    <span class="wpsh-slider round"></span>
                </label>
            </div>
        </div>
    </div>

    <!-- Main Grid -->
    <div class="wpsh-main-grid">
        <!-- Sidebar Navigation -->
        <div class="wpsh-sidebar">
            <nav class="wpsh-nav">
                <a href="#dashboard" class="wpsh-nav-item active" data-tab="dashboard">
                    <span class="dashicons dashicons-dashboard"></span> <?php esc_html_e('Dashboard', 'wp-static-html-pages'); ?>
                </a>
                <a href="#tools" class="wpsh-nav-item <?php echo !$enabled ? 'wpsh-nav-disabled' : ''; ?>" data-tab="tools">
                    <span class="dashicons dashicons-admin-tools"></span> <?php esc_html_e('Tools', 'wp-static-html-pages'); ?>
                </a>
                <a href="#settings" class="wpsh-nav-item <?php echo !$enabled ? 'wpsh-nav-disabled' : ''; ?>" data-tab="settings">
                    <span class="dashicons dashicons-admin-generic"></span> <?php esc_html_e('Settings', 'wp-static-html-pages'); ?>
                </a>
                <a href="#licence" class="wpsh-nav-item" data-tab="licence">
                    <span class="dashicons dashicons-admin-network"></span> <?php esc_html_e('Licence', 'wp-static-html-pages'); ?>
                </a>
            </nav>
            <div class="wpsh-sidebar-footer">
                v1.0.0
            </div>
        </div>

        <!-- Content Area -->
        <div class="wpsh-content">
            
            <!-- Dashboard Tab -->
            <div id="wpsh-tab-dashboard" class="wpsh-tab-content active">
                <?php if (!$license_active) : ?>
                <div class="wpsh-license-notice">
                    <span class="dashicons dashicons-warning"></span>
                    <p><?php esc_html_e('Activate your license in the Licence tab to enable plugin functionality.', 'wp-static-html-pages'); ?></p>
                    <a href="#licence" class="wpsh-btn primary mini wpsh-goto-licence"><?php esc_html_e('Go to Licence', 'wp-static-html-pages'); ?></a>
                </div>
                <?php endif; ?>
                <div class="wpsh-stats-row">
                    <div class="wpsh-stat-card">
                        <div class="stat-icon blue"><span class="dashicons dashicons-media-text"></span></div>
                        <div class="stat-value" id="wpsh-cached-count"><?php echo number_format($cached_count); ?></div>
                        <div class="stat-label"><?php esc_html_e('Files Cached', 'wp-static-html-pages'); ?></div>
                    </div>
                    <div class="wpsh-stat-card">
                        <div class="stat-icon green"><span class="dashicons dashicons-admin-links"></span></div>
                        <div class="stat-value"><?php echo number_format($total_reachable); ?></div>
                        <div class="stat-label"><?php esc_html_e('Total Reachable', 'wp-static-html-pages'); ?></div>
                    </div>
                    <div class="wpsh-stat-card">
                        <div class="stat-icon purple"><span class="dashicons dashicons-performance"></span></div>
                        <div class="stat-value"><?php echo ($total_reachable > 0) ? round(($cached_count / $total_reachable) * 100) : 0; ?>%</div>
                        <div class="stat-label"><?php esc_html_e('Coverage', 'wp-static-html-pages'); ?></div>
                    </div>
                </div>

                <div class="wpsh-card main-action-card wpsh-requires-enabled <?php echo !$effective_enabled ? 'wpsh-disabled' : ''; ?>">
                    <div class="wpsh-card-header">
                        <h2><?php esc_html_e('Site Generation', 'wp-static-html-pages'); ?></h2>
                        <p><?php esc_html_e('Process your entire site into static HTML files.', 'wp-static-html-pages'); ?></p>
                    </div>
                    <div class="wpsh-action-body">
                        <div class="wpsh-progress-wrap" id="wpsh-progress-wrap" style="display:none;">
                            <div class="wpsh-progress-info">
                                <span id="wpsh-progress-label"><?php esc_html_e('Starting...', 'wp-static-html-pages'); ?></span>
                                <span id="wpsh-progress-percent">0%</span>
                            </div>
                            <div class="wpsh-progress-bar"><div id="wpsh-progress-fill"></div></div>
                        </div>
                        <div class="wpsh-buttons">
                            <button id="wpsh-generate-btn" class="wpsh-btn primary" <?php echo !$effective_enabled ? ' disabled' : ''; ?>>
                                <span class="dashicons dashicons-update"></span> <?php esc_html_e('Run Bulk Generator', 'wp-static-html-pages'); ?>
                            </button>
                            <button id="wpsh-clear-btn" class="wpsh-btn secondary" <?php echo !$effective_enabled ? ' disabled' : ''; ?>>
                                <span class="dashicons dashicons-trash"></span> <?php esc_html_e('Clear Cache', 'wp-static-html-pages'); ?>
                            </button>
                        </div>
                    </div>
                    <div class="wpsh-log-wrap" style="display:none;">
                        <div class="wpsh-log-header">
                            <span><?php esc_html_e('Activity Log', 'wp-static-html-pages'); ?></span>
                            <button class="wpsh-log-clear"><?php esc_html_e('Clear', 'wp-static-html-pages'); ?></button>
                        </div>
                        <div id="wpsh-log" class="wpsh-log"></div>
                    </div>
                </div>

                <div class="wpsh-card wpsh-requires-enabled <?php echo !$enabled ? 'wpsh-disabled' : ''; ?>">
                    <div class="wpsh-card-header">
                        <h2><?php esc_html_e('Server Rules', 'wp-static-html-pages'); ?></h2>
                        <p><?php esc_html_e('Add these rules to your .htaccess file (WordPress root) to serve static HTML via Apache. Use the button to insert them automatically.', 'wp-static-html-pages'); ?></p>
                    </div>
                    <div class="wpsh-action-body">
                        <div class="wpsh-htaccess-block">
                            <div class="wpsh-htaccess-block-header">
                                <span class="wpsh-htaccess-block-title"><?php esc_html_e('Rules for .htaccess', 'wp-static-html-pages'); ?></span>
                                <button type="button" class="wpsh-htaccess-copy" id="wpsh-copy-htaccess-btn" title="<?php esc_attr_e('Copy to clipboard', 'wp-static-html-pages'); ?>">
                                    <span class="dashicons dashicons-clipboard"></span> <?php esc_html_e('Copy', 'wp-static-html-pages'); ?>
                                </button>
                            </div>
                            <pre class="wpsh-htaccess-rules"><code id="wpsh-htaccess-rules"><?php echo esc_html($core->get_htaccess_rules()); ?></code></pre>
                        </div>
                        <div class="wpsh-htaccess-actions">
                            <button id="wpsh-update-htaccess-btn" class="wpsh-btn primary" <?php echo !$effective_enabled ? ' disabled' : ''; ?>>
                                <span class="dashicons dashicons-admin-settings"></span> <?php esc_html_e('Update .htaccess Rules', 'wp-static-html-pages'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tools Tab -->
            <div id="wpsh-tab-tools" class="wpsh-tab-content">
                <div class="wpsh-card">
                    <div class="wpsh-card-header">
                        <h2><?php esc_html_e('Post Type Exclusions', 'wp-static-html-pages'); ?></h2>
                        <p><?php esc_html_e('Prevent specific post types from being cached.', 'wp-static-html-pages'); ?></p>
                    </div>
                    <div class="wpsh-pt-list">
                        <?php 
                        $all_pts = get_post_types(['public' => true], 'objects');
                        $pt_hidden = ['attachment'];
                        foreach ($all_pts as $pt) :
                            if (in_array($pt->name, $pt_hidden, true)) continue;
                            $is_always_included = in_array($pt->name, ['post', 'page'], true);
                            $is_excluded = $is_always_included ? false : in_array($pt->name, $excluded_pts);
                        ?>
                            <div class="wpsh-pt-item <?php echo $is_excluded ? 'excluded' : ''; ?> <?php echo $is_always_included ? 'wpsh-pt-always-included' : ''; ?>">
                                <div class="wpsh-pt-info">
                                    <span class="wpsh-pt-label"><?php echo esc_html($pt->label); ?></span>
                                    <code class="wpsh-pt-slug"><?php echo esc_html($pt->name); ?></code>
                                    <?php if ($is_always_included) : ?>
                                        <span class="wpsh-pt-hint"><?php esc_html_e('Always cached', 'wp-static-html-pages'); ?></span>
                                    <?php endif; ?>
                                </div>
                                <label class="wpsh-switch mini" title="<?php echo $is_always_included ? esc_attr__('Always cached; cannot be excluded.', 'wp-static-html-pages') : ''; ?>">
                                    <input type="checkbox" class="wpsh-pt-toggle" data-pt="<?php echo esc_attr($pt->name); ?>" <?php checked($is_excluded); ?> <?php echo $is_always_included ? ' disabled' : ''; ?>>
                                    <span class="wpsh-slider round"></span>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="wpsh-card">
                    <div class="wpsh-card-header">
                        <h2><?php esc_html_e('Taxonomy Exclusions', 'wp-static-html-pages'); ?></h2>
                        <p><?php esc_html_e('Prevent specific taxonomies from being cached.', 'wp-static-html-pages'); ?></p>
                    </div>
                    <div class="wpsh-pt-list">
                        <?php 
                        $all_taxes = get_taxonomies(['public' => true], 'objects');
                        foreach ($all_taxes as $tax) : 
                            $is_excluded = in_array($tax->name, $excluded_taxes);
                        ?>
                            <div class="wpsh-pt-item wpsh-tax-item <?php echo $is_excluded ? 'excluded' : ''; ?>">
                                <div class="wpsh-pt-info">
                                    <span class="wpsh-pt-label"><?php echo esc_html($tax->label); ?></span>
                                    <code class="wpsh-pt-slug"><?php echo esc_html($tax->name); ?></code>
                                </div>
                                <label class="wpsh-switch mini">
                                    <input type="checkbox" class="wpsh-tax-toggle" data-tax="<?php echo esc_attr($tax->name); ?>" <?php checked($is_excluded); ?>>
                                    <span class="wpsh-slider round"></span>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Settings Tab -->
            <div id="wpsh-tab-settings" class="wpsh-tab-content">
                <div class="wpsh-card">
                    <div class="wpsh-card-header">
                        <h2><?php esc_html_e('Plugin Settings', 'wp-static-html-pages'); ?></h2>
                    </div>
                    <div class="wpsh-settings-grid">
                        <div class="wpsh-setting-item">
                            <div class="wpsh-setting-info">
                                <span class="wpsh-setting-label"><?php esc_html_e('Auto-regenerate on Save', 'wp-static-html-pages'); ?></span>
                                <p class="description"><?php esc_html_e('Automatically update static HTML when saving posts.', 'wp-static-html-pages'); ?></p>
                            </div>
                            <label class="wpsh-switch">
                                <input type="checkbox" id="wpsh-auto-regen-toggle" <?php checked(get_option('wpsh_auto_regen', '1'), '1'); ?>>
                                <span class="wpsh-slider round"></span>
                            </label>
                        </div>
                        <div class="wpsh-setting-item vertical">
                            <span class="wpsh-setting-label"><?php esc_html_e('Global URL Exclusions', 'wp-static-html-pages'); ?></span>
                            <textarea id="wpsh-url-exclusions" class="wpsh-textarea"><?php echo esc_textarea(get_option('wpsh_url_exclusions', '')); ?></textarea>
                            <button id="wpsh-save-exclusions-btn" class="wpsh-btn secondary mini"><?php esc_html_e('Save Exclusion List', 'wp-static-html-pages'); ?></button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Licence Tab -->
            <div id="wpsh-tab-licence" class="wpsh-tab-content">
                <div class="wpsh-card">
                    <div class="wpsh-card-header">
                        <h2><?php esc_html_e('License Activation', 'wp-static-html-pages'); ?></h2>
                        <p><?php esc_html_e('Enter your license key to activate the plugin and receive updates.', 'wp-static-html-pages'); ?></p>
                    </div>
                    <div class="wpsh-licence-body">
                        <?php
                        $license = WPSH_License::get_instance();
                        $license_info = $license->get_license_info();
                        $is_activated = ($license_info['status'] === 'active');
                        $license_data = $license_info['data'];
                        ?>
                        <div class="wpsh-licence-status <?php echo $is_activated ? 'wpsh-licence-active' : 'wpsh-licence-inactive'; ?>">
                            <div class="wpsh-licence-status-icon">
                                <span class="dashicons <?php echo $is_activated ? 'dashicons-yes-alt' : 'dashicons-warning'; ?>"></span>
                            </div>
                            <div class="wpsh-licence-status-text">
                                <strong><?php echo $is_activated ? esc_html__('License Active', 'wp-static-html-pages') : esc_html__('License Inactive', 'wp-static-html-pages'); ?></strong>
                                <p><?php echo $is_activated ? esc_html__('Your license is active and valid.', 'wp-static-html-pages') : esc_html__('Please activate your license to receive updates and support.', 'wp-static-html-pages'); ?></p>
                                <?php if ($is_activated && !empty($license_info['expires']) && $license_info['expires'] !== 'lifetime') : ?>
                                    <p class="wpsh-licence-expiry">
                                        <strong><?php esc_html_e('Expires:', 'wp-static-html-pages'); ?></strong> 
                                        <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($license_info['expires']))); ?>
                                    </p>
                                <?php elseif ($is_activated && isset($license_info['expires']) && $license_info['expires'] === 'lifetime') : ?>
                                    <p class="wpsh-licence-expiry">
                                        <strong><?php esc_html_e('License Type:', 'wp-static-html-pages'); ?></strong> 
                                        <?php esc_html_e('Lifetime', 'wp-static-html-pages'); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if ($is_activated && !empty($license_info['customer_name'])) : ?>
                                    <p class="wpsh-licence-customer">
                                        <strong><?php esc_html_e('Customer:', 'wp-static-html-pages'); ?></strong> 
                                        <?php echo esc_html($license_info['customer_name']); ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="wpsh-licence-form">
                            <div class="wpsh-setting-item vertical">
                                <label for="wpsh-license-key" class="wpsh-setting-label"><?php esc_html_e('License Key', 'wp-static-html-pages'); ?></label>
                                <input type="text" id="wpsh-license-key" class="wpsh-license-input" value="<?php echo esc_attr($license_info['key']); ?>" placeholder="<?php esc_attr_e('Enter your license key', 'wp-static-html-pages'); ?>">
                                <p class="description"><?php esc_html_e('You can find your license key in your account dashboard.', 'wp-static-html-pages'); ?></p>
                            </div>
                            <div class="wpsh-licence-actions">
                                <button id="wpsh-activate-license-btn" class="wpsh-btn primary">
                                    <span class="dashicons dashicons-admin-network"></span> <?php esc_html_e('Activate License', 'wp-static-html-pages'); ?>
                                </button>
                                <?php if ($is_activated) : ?>
                                    <button id="wpsh-check-license-btn" class="wpsh-btn secondary">
                                        <span class="dashicons dashicons-update"></span> <?php esc_html_e('Check License', 'wp-static-html-pages'); ?>
                                    </button>
                                    <button id="wpsh-deactivate-license-btn" class="wpsh-btn secondary">
                                        <span class="dashicons dashicons-dismiss"></span> <?php esc_html_e('Deactivate License', 'wp-static-html-pages'); ?>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Toaster for Notifications -->
    <div id="wpsh-toaster" class="wpsh-toaster"></div>
</div>
<?php
// No more inline script here - logic moved to assets/js/admin.js
?>
