<?php
// Direct SQL insert for abandoned carts
require_once('../../../wp-load.php');

global $wpdb;
$table_name = $wpdb->prefix . 'abandoned_carts';

echo "<h2>Inserting Abandoned Cart Data</h2>";

// Clear existing data
$wpdb->query("TRUNCATE TABLE $table_name");
echo "<p>✓ Cleared existing data</p>";

// Direct SQL inserts
$inserts = array(
    "INSERT INTO $table_name (user_email, cart_contents, cart_total, status, created_at) VALUES ('john.doe@example.com', '{\"items\":[{\"name\":\"Wireless Headphones\",\"quantity\":1,\"price\":79.99},{\"name\":\"Phone Case\",\"quantity\":2,\"price\":15.99}]}', 111.97, 'abandoned', NOW() - INTERVAL 3 HOUR)",
    
    "INSERT INTO $table_name (user_email, cart_contents, cart_total, status, created_at) VALUES ('jane.smith@example.com', '{\"items\":[{\"name\":\"Laptop Stand\",\"quantity\":1,\"price\":49.99}]}', 49.99, 'abandoned', NOW() - INTERVAL 1 DAY)",
    
    "INSERT INTO $table_name (user_email, cart_contents, cart_total, status, created_at) VALUES ('bob.wilson@example.com', '{\"items\":[{\"name\":\"USB Cable\",\"quantity\":3,\"price\":9.99},{\"name\":\"Mouse Pad\",\"quantity\":1,\"price\":12.99}]}', 42.96, 'emailed', NOW() - INTERVAL 2 DAY)",
    
    "INSERT INTO $table_name (user_email, cart_contents, cart_total, status, created_at) VALUES ('alice.johnson@example.com', '{\"items\":[{\"name\":\"Keyboard\",\"quantity\":1,\"price\":89.99}]}', 89.99, 'recovered', NOW() - INTERVAL 5 DAY)",
    
    "INSERT INTO $table_name (user_email, cart_contents, cart_total, status, created_at) VALUES ('mike.brown@example.com', '{\"items\":[{\"name\":\"Monitor\",\"quantity\":1,\"price\":299.99},{\"name\":\"HDMI Cable\",\"quantity\":1,\"price\":14.99}]}', 314.98, 'abandoned', NOW() - INTERVAL 6 HOUR)"
);

foreach ($inserts as $index => $sql) {
    $result = $wpdb->query($sql);
    if ($result) {
        echo "<p style='color: green;'>✓ Inserted cart " . ($index + 1) . "</p>";
    } else {
        echo "<p style='color: red;'>✗ Failed cart " . ($index + 1) . ": " . $wpdb->last_error . "</p>";
    }
}

// Verify data
$count = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
echo "<h3>Verification</h3>";
echo "<p><strong>Total rows in table:</strong> $count</p>";

if ($count > 0) {
    $carts = $wpdb->get_results("SELECT * FROM $table_name ORDER BY created_at DESC");
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%; margin-top: 20px;'>";
    echo "<tr style='background: #0073aa; color: white;'><th>ID</th><th>Email</th><th>Total</th><th>Status</th><th>Created</th></tr>";
    foreach ($carts as $cart) {
        $status_color = $cart->status === 'abandoned' ? '#ff9800' : ($cart->status === 'recovered' ? '#4caf50' : '#2196f3');
        echo "<tr>";
        echo "<td>{$cart->id}</td>";
        echo "<td>{$cart->user_email}</td>";
        echo "<td>\${$cart->cart_total}</td>";
        echo "<td style='color: $status_color; font-weight: bold;'>{$cart->status}</td>";
        echo "<td>{$cart->created_at}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<div style='background: #d4edda; padding: 20px; margin-top: 30px; border-radius: 5px; border: 2px solid #28a745;'>";
    echo "<h3 style='color: #155724; margin-top: 0;'>✓ SUCCESS!</h3>";
    echo "<p style='color: #155724; font-size: 16px;'>Successfully inserted $count abandoned carts into the database.</p>";
    echo "<p><a href='" . admin_url('admin.php?page=ai-growth-suite-abandoned-carts') . "' style='display: inline-block; background: #28a745; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; font-weight: bold;'>→ View Abandoned Carts Page</a></p>";
    echo "</div>";
} else {
    echo "<p style='color: red; font-size: 18px;'><strong>ERROR:</strong> No data was inserted!</p>";
    echo "<p>Last error: " . $wpdb->last_error . "</p>";
}
?>
