<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AI_Growth_Suite_Email_Engine {

	public function __construct() {
		// Hooks for various email triggers
		add_action( 'woocommerce_order_status_completed', array( $this, 'send_post_purchase_emails' ) );
		add_action( 'user_register', array( $this, 'send_welcome_email' ) );
	}

	/**
	 * Send Email
	 *
	 * @param string $to
	 * @param string $subject
	 * @param string $message
	 * @param string $type
	 */
	public function send_email( $to, $subject, $message, $type = 'general' ) {
		$headers = array( 'Content-Type: text/html; charset=UTF-8' );
		$sent = wp_mail( $to, $subject, $message, $headers );

		if ( $sent ) {
			$this->log_email( $to, $subject, $type, 'sent' );
		} else {
			$this->log_email( $to, $subject, $type, 'failed' );
		}
	}

	/**
	 * Replace Tokens
	 *
	 * @param string $content
	 * @param array $data
	 * @return string
	 */
	public function replace_tokens( $content, $data ) {
		foreach ( $data as $key => $value ) {
			$content = str_replace( '{' . $key . '}', $value, $content );
		}
		return $content;
	}

	/**
	 * Log Email
	 */
	private function log_email( $to, $subject, $type, $status ) {
		global $wpdb;
		$table_name = $wpdb->prefix . 'ai_email_log';
		$wpdb->insert( 
			$table_name, 
			array( 
				'email_to' => $to, 
				'email_subject' => $subject, 
				'email_type' => $type, 
				'sent_at' => current_time( 'mysql' ),
				'status' => $status
			) 
		);
	}

	/**
	 * Send Welcome Email
	 */
	public function send_welcome_email( $user_id ) {
		$user = get_userdata( $user_id );
		$subject = "Welcome to {store_name}!";
		$message = "Hi {name}, thanks for joining us.";

		$data = array(
			'name' => $user->display_name,
			'store_name' => get_bloginfo( 'name' )
		);

		$subject = $this->replace_tokens( $subject, $data );
		$message = $this->replace_tokens( $message, $data );

		$this->send_email( $user->user_email, $subject, $message, 'welcome' );
	}

	/**
	 * Send Post Purchase Upsell (Example)
	 */
	public function send_post_purchase_emails( $order_id ) {
		// Logic to schedule or send upsell email
	}
}
