<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AI_Growth_Suite_Analytics {

	public function __construct() {
		add_action( 'wp_footer', array( $this, 'track_page_view' ) );
		add_action( 'woocommerce_add_to_cart', array( $this, 'track_add_to_cart' ), 10, 6 );
		add_action( 'woocommerce_thankyou', array( $this, 'track_purchase' ) );
	}

	/**
	 * Track Page View
	 */
	public function track_page_view() {
		if ( is_product() ) {
			$this->log_event( 'product_view', array( 'product_id' => get_the_ID() ) );
		}
	}

	/**
	 * Track Add to Cart
	 */
	public function track_add_to_cart( $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data ) {
		$this->log_event( 'add_to_cart', array( 'product_id' => $product_id, 'quantity' => $quantity ) );
	}

	/**
	 * Track Purchase
	 */
	public function track_purchase( $order_id ) {
		$order = wc_get_order( $order_id );
		if ( ! $order ) return;

		$this->log_event( 'purchase', array( 'order_id' => $order_id, 'total' => $order->get_total() ) );
	}

	/**
	 * Log Event to DB
	 */
	private function log_event( $type, $data ) {
		if ( ! function_exists( 'ai_growth_suite_table_exists' ) || ! ai_growth_suite_table_exists( 'ai_events' ) ) {
			return;
		}
		global $wpdb;
		$table_name = $wpdb->prefix . 'ai_events';
		
		$user_id = get_current_user_id();

		$wpdb->insert( 
			$table_name, 
			array( 
				'event_type' => $type, 
				'event_data' => json_encode( $data ), 
				'created_at' => current_time( 'mysql' ),
				'user_id' => $user_id
			) 
		);
	}
}
