<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AI_Growth_Suite_AI_Engine {

	public function __construct() {
		// Hooks if needed
	}

	/**
	 * Generate text content using AI
	 *
	 * @param string $prompt
	 * @param array $context
	 * @return string
	 */
	public function generate_text( $prompt, $context = array() ) {
		// Placeholder for API call (e.g., OpenAI)
		// $api_key = get_option('ai_growth_suite_api_key');
		// ... make request ...

		// Mock response for now
		return "This is a simulated AI response for prompt: " . substr($prompt, 0, 50) . "...";
	}

	/**
	 * Generate JSON content using AI
	 *
	 * @param string $prompt
	 * @param array $context
	 * @return array
	 */
	public function generate_json( $prompt, $context = array() ) {
		// Mock response
		return array(
			'success' => true,
			'data' => array(
				'suggestion' => 'Simulated AI suggestion',
				'score' => 0.95
			)
		);
	}

	/**
	 * Generate Product Description
	 *
	 * @param int $product_id
	 * @return array
	 */
	public function generate_product_description( $product_id ) {
		$product = wc_get_product( $product_id );
		if ( ! $product ) {
			return false;
		}

		$api_key = get_option( 'ai_growth_suite_api_key' );
		if ( empty( $api_key ) ) {
			return new WP_Error( 'missing_key', 'AI API Key is missing in settings.' );
		}

		$name = $product->get_name();
		$cats = wc_get_product_category_list( $product_id );
		$prompt = "Write a compelling, SEO-optimized product description for an eCommerce product named '{$name}'. Categories: {$cats}. Return the result as a JSON object with keys: 'description' (HTML long description), 'short_description' (plain text), and 'features' (bullet points in HTML). Tone: Professional yet persuasive.";

		$response = wp_remote_post( 'https://api.openai.com/v1/chat/completions', array(
			'headers' => array(
				'Authorization' => 'Bearer ' . $api_key,
				'Content-Type'  => 'application/json',
			),
			'body'    => json_encode( array(
				'model'       => 'gpt-3.5-turbo',
				'messages'    => array(
					array( 'role' => 'system', 'content' => 'You are an expert eCommerce copywriter.' ),
					array( 'role' => 'user', 'content' => $prompt ),
				),
				'temperature' => 0.7,
			) ),
			'timeout' => 30,
		) );

		if ( is_wp_error( $response ) ) {
			return $response;
		}

		$body = wp_remote_retrieve_body( $response );
		$data = json_decode( $body, true );

		if ( isset( $data['error'] ) ) {
			return new WP_Error( 'openai_error', $data['error']['message'] );
		}

		if ( isset( $data['choices'][0]['message']['content'] ) ) {
			$content = $data['choices'][0]['message']['content'];
			// Try to parse JSON from content
			$json_start = strpos( $content, '{' );
			$json_end = strrpos( $content, '}' );
			
			if ( $json_start !== false && $json_end !== false ) {
				$json_str = substr( $content, $json_start, $json_end - $json_start + 1 );
				$result = json_decode( $json_str, true );
				
				if ( $result ) {
					return $result;
				}
			}
			
			// Fallback if JSON parsing fails
			return array(
				'description' => $content,
				'short_description' => substr( strip_tags( $content ), 0, 150 ) . '...',
				'features' => ''
			);
		}

		return false;
	}

	/**
	 * Generate Upsell/Cross-sell Suggestions
	 * 
	 * @param int $product_id
	 * @return array
	 */
	public function generate_recommendations( $product_id ) {
		// In a real scenario, this would analyze the product and find related ones.
		// Here we just return some random products as a mock.
		
		$args = array(
			'limit' => 3,
			'exclude' => array( $product_id ),
			'status' => 'publish',
		);
		$products = wc_get_products( $args );
		$ids = array();
		foreach ( $products as $p ) {
			$ids[] = $p->get_id();
		}

		return $ids;
	}
}
