<?php
// Force create abandoned carts table
require_once('../../../wp-load.php');

global $wpdb;
$table_name = $wpdb->prefix . 'abandoned_carts';

echo "<h2>Force Creating Abandoned Carts Table</h2>";

// Drop existing table if exists
$wpdb->query("DROP TABLE IF EXISTS $table_name");
echo "<p>✓ Dropped existing table (if any)</p>";

// Create table
$charset_collate = $wpdb->get_charset_collate();
$sql = "CREATE TABLE $table_name (
    id bigint(20) NOT NULL AUTO_INCREMENT,
    user_email varchar(255) NOT NULL,
    cart_contents longtext NOT NULL,
    cart_total decimal(10,2) NOT NULL DEFAULT 0.00,
    status varchar(50) NOT NULL DEFAULT 'abandoned',
    created_at datetime NOT NULL,
    PRIMARY KEY (id),
    KEY user_email (user_email),
    KEY status (status)
) $charset_collate;";

require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
dbDelta($sql);

echo "<p>✓ Created table: $table_name</p>";

// Verify table exists
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'") === $table_name;
echo "<p><strong>Table exists:</strong> " . ($table_exists ? 'YES ✓' : 'NO ✗') . "</p>";

if ($table_exists) {
    // Insert multiple sample carts
    $sample_carts = array(
        array(
            'user_email' => 'john.doe@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'Wireless Headphones', 'quantity' => 1, 'price' => 79.99),
                array('name' => 'Phone Case', 'quantity' => 2, 'price' => 15.99)
            )),
            'cart_total' => 111.97,
            'status' => 'abandoned',
            'created_at' => date('Y-m-d H:i:s', strtotime('-3 hours'))
        ),
        array(
            'user_email' => 'jane.smith@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'Laptop Stand', 'quantity' => 1, 'price' => 49.99)
            )),
            'cart_total' => 49.99,
            'status' => 'abandoned',
            'created_at' => date('Y-m-d H:i:s', strtotime('-1 day'))
        ),
        array(
            'user_email' => 'bob.wilson@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'USB Cable', 'quantity' => 3, 'price' => 9.99),
                array('name' => 'Mouse Pad', 'quantity' => 1, 'price' => 12.99)
            )),
            'cart_total' => 42.96,
            'status' => 'emailed',
            'created_at' => date('Y-m-d H:i:s', strtotime('-2 days'))
        ),
        array(
            'user_email' => 'alice.johnson@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'Keyboard', 'quantity' => 1, 'price' => 89.99)
            )),
            'cart_total' => 89.99,
            'status' => 'recovered',
            'created_at' => date('Y-m-d H:i:s', strtotime('-5 days'))
        ),
        array(
            'user_email' => 'mike.brown@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'Monitor', 'quantity' => 1, 'price' => 299.99),
                array('name' => 'HDMI Cable', 'quantity' => 1, 'price' => 14.99)
            )),
            'cart_total' => 314.98,
            'status' => 'abandoned',
            'created_at' => date('Y-m-d H:i:s', strtotime('-6 hours'))
        )
    );
    
    echo "<h3>Inserting Sample Data...</h3>";
    foreach ($sample_carts as $index => $cart) {
        $result = $wpdb->insert(
            $table_name,
            $cart,
            array('%s', '%s', '%f', '%s', '%s')
        );
        
        if ($result) {
            echo "<p>✓ Inserted cart " . ($index + 1) . ": {$cart['user_email']} - \${$cart['cart_total']}</p>";
        } else {
            echo "<p style='color:red;'>✗ Failed to insert cart " . ($index + 1) . ": " . $wpdb->last_error . "</p>";
        }
    }
    
    // Show results
    echo "<h3>Current Data in Table:</h3>";
    $carts = $wpdb->get_results("SELECT * FROM $table_name");
    echo "<p><strong>Total rows:</strong> " . count($carts) . "</p>";
    
    if (!empty($carts)) {
        echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Email</th><th>Total</th><th>Status</th><th>Created</th></tr>";
        foreach ($carts as $cart) {
            echo "<tr>";
            echo "<td>{$cart->id}</td>";
            echo "<td>{$cart->user_email}</td>";
            echo "<td>\${$cart->cart_total}</td>";
            echo "<td><strong>{$cart->status}</strong></td>";
            echo "<td>{$cart->created_at}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    echo "<br><br>";
    echo "<p style='background: #d4edda; padding: 15px; border: 1px solid #c3e6cb; border-radius: 5px;'>";
    echo "<strong>✓ SUCCESS!</strong> Table created and populated with " . count($carts) . " sample carts.";
    echo "</p>";
    
    echo "<p><a href='" . admin_url('admin.php?page=ai-growth-suite-abandoned-carts') . "' style='display: inline-block; background: #0073aa; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>→ Go to Abandoned Carts Page</a></p>";
} else {
    echo "<p style='color: red;'><strong>ERROR:</strong> Failed to create table!</p>";
    echo "<p>Last error: " . $wpdb->last_error . "</p>";
}
