<?php
require_once('../../../wp-load.php');
require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

global $wpdb;
$charset_collate = $wpdb->get_charset_collate();

echo "Fixing Database Tables...\n";

// Table: wp_ai_recommendations
$table_name = $wpdb->prefix . 'ai_recommendations';
$sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    product_id bigint(20) NOT NULL,
    recommendations longtext NOT NULL,
    generated_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
    PRIMARY KEY  (id)
) $charset_collate;";
dbDelta( $sql );
echo "Created/Updated $table_name\n";

// Table: wp_dynamic_pricing_rules
$table_name = $wpdb->prefix . 'dynamic_pricing_rules';
$sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    rule_name varchar(255) NOT NULL,
    rule_type varchar(50) NOT NULL,
    conditions longtext NOT NULL,
    actions longtext NOT NULL,
    is_active boolean DEFAULT 1 NOT NULL,
    PRIMARY KEY  (id)
) $charset_collate;";
dbDelta( $sql );
echo "Created/Updated $table_name\n";

// Table: wp_abandoned_carts
$table_name = $wpdb->prefix . 'abandoned_carts';
$sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    user_email varchar(100) NOT NULL,
    cart_contents longtext NOT NULL,
    cart_total float NOT NULL,
    created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
    status varchar(20) DEFAULT 'abandoned' NOT NULL,
    recovered_at datetime DEFAULT NULL,
    PRIMARY KEY  (id)
) $charset_collate;";
dbDelta( $sql );
echo "Created/Updated $table_name\n";

// Table: wp_ai_email_log
$table_name = $wpdb->prefix . 'ai_email_log';
$sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    email_to varchar(100) NOT NULL,
    email_subject varchar(255) NOT NULL,
    email_type varchar(50) NOT NULL,
    sent_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
    status varchar(20) NOT NULL,
    PRIMARY KEY  (id)
) $charset_collate;";
dbDelta( $sql );
echo "Created/Updated $table_name\n";

// Table: wp_ab_tests
$table_name = $wpdb->prefix . 'ab_tests';
$sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    product_id bigint(20) NOT NULL,
    test_type varchar(50) NOT NULL,
    variant_a longtext NOT NULL,
    variant_b longtext NOT NULL,
    traffic_split int DEFAULT 50 NOT NULL,
    start_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
    end_date datetime DEFAULT NULL,
    status varchar(20) DEFAULT 'running' NOT NULL,
    PRIMARY KEY  (id)
) $charset_collate;";
dbDelta( $sql );
echo "Created/Updated $table_name\n";

// Table: wp_ai_events (for analytics)
$table_name = $wpdb->prefix . 'ai_events';
$sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    event_type varchar(50) NOT NULL,
    event_data longtext NOT NULL,
    created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
    user_id bigint(20) DEFAULT 0,
    PRIMARY KEY  (id)
) $charset_collate;";
dbDelta( $sql );
echo "Created/Updated $table_name\n";

// Table: wp_ai_licenses (PRO)
$table_name = $wpdb->prefix . 'ai_licenses';
$sql = "CREATE TABLE $table_name (
    id mediumint(9) NOT NULL AUTO_INCREMENT,
    license_key varchar(255) NOT NULL,
    status varchar(20) NOT NULL,
    activated_at datetime DEFAULT NULL,
    expires_at datetime DEFAULT NULL,
    PRIMARY KEY  (id)
) $charset_collate;";
dbDelta( $sql );
echo "Created/Updated $table_name\n";

echo "Done.\n";
