<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Starting...\n";
require_once('../../../wp-load.php');
echo "WP Loaded.\n";

global $wpdb;
$table_name = $wpdb->prefix . 'ai_recommendations';

echo "Checking table: $table_name\n";

if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
    echo "Table does not exist!\n";
} else {
    echo "Table exists.\n";
    $count = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
    echo "Row count: $count\n";
}

if (function_exists('wc_get_products')) {
    echo "WooCommerce active.\n";
    $products = wc_get_products(array('limit' => -1));
    echo "Total Products: " . count($products) . "\n";
    if (count($products) > 0) {
        foreach ($products as $p) {
            echo "Product: " . $p->get_id() . "\n";
        }
    } else {
        echo "No products found via wc_get_products.\n";
        // Try direct DB query for posts
        $posts = $wpdb->get_results("SELECT ID, post_title FROM {$wpdb->prefix}posts WHERE post_type='product' LIMIT 5");
        echo "Direct DB check for products:\n";
        print_r($posts);
    }
} else {
    echo "WooCommerce NOT active.\n";
}
