<?php
require_once('../../../wp-load.php');

if (!class_exists('WooCommerce')) {
    die("WooCommerce not active.");
}

$products = wc_get_products(array('limit' => 1));
if (empty($products)) {
    die("No products found.");
}

$product = $products[0];
$original_price = $product->get_price();

echo "Product: " . $product->get_name() . "\n";
echo "Original Price: " . $original_price . "\n";

// Mock Cart for cart_value rule
if (!WC()->cart) {
    wc_load_cart();
}
// Force cart total for testing
WC()->cart->subtotal = 200; 
echo "Mock Cart Subtotal: " . WC()->cart->subtotal . "\n";

$pricing_engine = new AI_Growth_Suite_Dynamic_Pricing();
$new_price = $pricing_engine->apply_dynamic_pricing($original_price, $product);

echo "New Price: " . $new_price . "\n";

if ($new_price != $original_price) {
    echo "SUCCESS: Dynamic pricing applied.\n";
} else {
    echo "FAIL: Price did not change.\n";
    // Debug rules
    global $wpdb;
    $table_name = $wpdb->prefix . 'dynamic_pricing_rules';
    $rules = $wpdb->get_results( "SELECT * FROM $table_name WHERE is_active = 1" );
    echo "Active Rules:\n";
    print_r($rules);
}
