<?php
require_once('../../../wp-load.php');

if (!class_exists('WooCommerce')) {
    die("WooCommerce not active.");
}

$products = wc_get_products(array('limit' => 1));
if (empty($products)) {
    die("No products found.");
}

$product = $products[0];
$product_id = $product->get_id();
echo "Testing Product ID: $product_id\n";

$engine = new AI_Growth_Suite_Recommendation_Engine();
$recs = $engine->get_recommendations($product_id);

echo "Recommendations:\n";
print_r($recs);

if (empty($recs)) {
    echo "No recommendations returned.\n";
} else {
    echo "Rendering template...\n";
    // Mock global product
    global $product;
    $product = wc_get_product($product_id);
    
    // Capture output
    ob_start();
    $recommendations = $recs;
    include AI_GROWTH_SUITE_PATH . 'templates/recommendations.php';
    $output = ob_get_clean();
    
    echo "Template Output:\n";
    echo $output;
}
