<?php
require_once('../../../wp-load.php');

global $wpdb;
$charset_collate = $wpdb->get_charset_collate();
require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

// Table: wp_email_flows
$table_name = $wpdb->prefix . 'email_flows';
$sql = "CREATE TABLE $table_name (
	id mediumint(9) NOT NULL AUTO_INCREMENT,
	flow_name varchar(255) NOT NULL,
	flow_slug varchar(100) NOT NULL,
	trigger_type varchar(50) NOT NULL,
	ai_tone varchar(50) DEFAULT 'Friendly',
	is_active boolean DEFAULT 1 NOT NULL,
	created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
	PRIMARY KEY  (id),
	UNIQUE KEY flow_slug (flow_slug)
) $charset_collate;";

dbDelta( $sql );

echo "Email flows table created successfully!\n";
echo "Table name: " . $table_name . "\n";

// Check if table exists
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'");
if ($table_exists) {
	echo "✓ Table exists and is ready to use.\n";
} else {
	echo "✗ Table creation failed.\n";
}
