<?php
// Load WordPress
require_once('../../../wp-load.php');

global $wpdb;
$table_name = $wpdb->prefix . 'abandoned_carts';

// Check if table exists
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'") === $table_name;

echo "<h2>Abandoned Carts Debug</h2>";
echo "<p><strong>Table exists:</strong> " . ($table_exists ? 'Yes' : 'No') . "</p>";

if (!$table_exists) {
    echo "<p style='color: red;'>Table does not exist! Creating it now...</p>";
    
    $charset_collate = $wpdb->get_charset_collate();
    $sql = "CREATE TABLE $table_name (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        user_email varchar(255) NOT NULL,
        cart_contents longtext NOT NULL,
        cart_total decimal(10,2) NOT NULL DEFAULT 0.00,
        status varchar(50) NOT NULL DEFAULT 'abandoned',
        created_at datetime NOT NULL,
        PRIMARY KEY (id),
        KEY user_email (user_email),
        KEY status (status)
    ) $charset_collate;";
    
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
    
    echo "<p style='color: green;'>Table created!</p>";
    
    // Insert sample data
    $sample_data = array(
        array(
            'user_email' => 'customer1@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'Product A', 'quantity' => 2, 'price' => 29.99),
                array('name' => 'Product B', 'quantity' => 1, 'price' => 49.99)
            )),
            'cart_total' => 109.97,
            'status' => 'abandoned',
            'created_at' => date('Y-m-d H:i:s', strtotime('-2 hours'))
        ),
        array(
            'user_email' => 'customer2@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'Product C', 'quantity' => 1, 'price' => 79.99)
            )),
            'cart_total' => 79.99,
            'status' => 'abandoned',
            'created_at' => date('Y-m-d H:i:s', strtotime('-5 hours'))
        ),
        array(
            'user_email' => 'customer3@example.com',
            'cart_contents' => json_encode(array(
                array('name' => 'Product D', 'quantity' => 3, 'price' => 19.99)
            )),
            'cart_total' => 59.97,
            'status' => 'recovered',
            'created_at' => date('Y-m-d H:i:s', strtotime('-1 day'))
        )
    );
    
    foreach ($sample_data as $data) {
        $wpdb->insert($table_name, $data, array('%s', '%s', '%f', '%s', '%s'));
    }
    
    echo "<p style='color: green;'>Sample data inserted!</p>";
}

// Show table structure
echo "<h3>Table Structure:</h3>";
$columns = $wpdb->get_results("DESCRIBE $table_name");
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
foreach ($columns as $column) {
    echo "<tr>";
    echo "<td>{$column->Field}</td>";
    echo "<td>{$column->Type}</td>";
    echo "<td>{$column->Null}</td>";
    echo "<td>{$column->Key}</td>";
    echo "<td>{$column->Default}</td>";
    echo "</tr>";
}
echo "</table>";

// Show data
echo "<h3>Current Data:</h3>";
$carts = $wpdb->get_results("SELECT * FROM $table_name ORDER BY created_at DESC LIMIT 10");
echo "<p><strong>Total rows:</strong> " . count($carts) . "</p>";

if (!empty($carts)) {
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Email</th><th>Total</th><th>Status</th><th>Created</th><th>Items</th></tr>";
    foreach ($carts as $cart) {
        $items = json_decode($cart->cart_contents, true);
        $item_count = is_array($items) ? count($items) : 0;
        echo "<tr>";
        echo "<td>{$cart->id}</td>";
        echo "<td>{$cart->user_email}</td>";
        echo "<td>\${$cart->cart_total}</td>";
        echo "<td>{$cart->status}</td>";
        echo "<td>{$cart->created_at}</td>";
        echo "<td>{$item_count} items</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: orange;'>No data found in table.</p>";
}

echo "<br><p><a href='" . admin_url('admin.php?page=ai-growth-suite-abandoned-carts') . "'>Go to Abandoned Carts Page</a></p>";
