<?php
global $wpdb;
$currency = function_exists( 'get_woocommerce_currency_symbol' ) ? get_woocommerce_currency_symbol() : '$';
$table_name = $wpdb->prefix . 'ai_recommendations';

$recommendations = array();
if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'ai_recommendations' ) ) {
	$recommendations = $wpdb->get_results( "SELECT * FROM $table_name ORDER BY generated_at DESC" );
	if ( ! is_array( $recommendations ) ) {
		$recommendations = array();
	}
}
$total_recs = count( $recommendations );
// Mock stats for now as we don't have a full click tracking table yet
$ctr = '0%';
$revenue = 0;
?>
<div class="ai-growth-suite-upsell ags-upsell">
	<!-- Hero -->
	<div class="ags-upsell-hero">
		<div class="ags-upsell-hero-bg"></div>
		<div class="ags-upsell-hero-inner">
			<div class="ags-upsell-hero-icon">
				<svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"/><line x1="3" y1="6" x2="21" y2="6"/><path d="M16 10a4 4 0 0 1-8 0"/></svg>
			</div>
			<h1 class="ags-upsell-hero-title"><?php esc_html_e( 'Upsell & Cross-Sell Management', 'ai-growth-suite' ); ?></h1>
			<p class="ags-upsell-hero-desc"><?php esc_html_e( 'AI-powered product recommendations to increase average order value. Manage suggestions, track performance, and control where they appear.', 'ai-growth-suite' ); ?></p>
			<div class="ags-upsell-hero-actions">
				<button type="button" class="button button-primary ai-regenerate-upsells-btn"><?php esc_html_e( 'Force Regenerate All', 'ai-growth-suite' ); ?></button>
			</div>
		</div>
	</div>

	<div class="ags-upsell-stats">
		<div class="ags-upsell-stat-card">
			<span class="ags-upsell-stat-icon ags-upsell-stat-icon-suggestions">
				<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><path d="M12 2L2 7l10 5 10-5-10-5z"/><path d="M2 17l10 5 10-5"/></svg>
			</span>
			<div class="ags-upsell-stat-body">
				<h4><?php esc_html_e( 'Active Suggestions', 'ai-growth-suite' ); ?></h4>
				<div class="value"><?php echo intval( $total_recs ); ?></div>
			</div>
		</div>
		<div class="ags-upsell-stat-card">
			<span class="ags-upsell-stat-icon ags-upsell-stat-icon-ctr">
				<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><path d="M22 12h-4l-3 9L9 3l-3 9H2"/></svg>
			</span>
			<div class="ags-upsell-stat-body">
				<h4><?php esc_html_e( 'Click-Through Rate', 'ai-growth-suite' ); ?></h4>
				<div class="value"><?php echo esc_html( $ctr ); ?></div>
			</div>
		</div>
		<div class="ags-upsell-stat-card">
			<span class="ags-upsell-stat-icon ags-upsell-stat-icon-revenue">
				<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="1" x2="12" y2="23"/><path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/></svg>
			</span>
			<div class="ags-upsell-stat-body">
				<h4><?php esc_html_e( 'Attributed Revenue', 'ai-growth-suite' ); ?></h4>
				<div class="value"><?php echo esc_html( $currency . number_format( $revenue, 2 ) ); ?></div>
			</div>
		</div>
	</div>

	<div class="card ags-upsell-card">
		<div class="ags-upsell-card-head">
			<h3><?php esc_html_e( 'Active Suggestions', 'ai-growth-suite' ); ?></h3>
			<p class="ags-upsell-card-desc"><?php esc_html_e( 'Search and manage AI-generated upsell and cross-sell recommendations per product.', 'ai-growth-suite' ); ?></p>
		</div>
		<div class="ags-upsell-toolbar tablenav top">
			<div class="ags-toolbar-group">
				<input type="text" id="ai-upsell-search-input" class="ags-upsell-search-input" placeholder="<?php esc_attr_e( 'Search product...', 'ai-growth-suite' ); ?>" />
				<button type="button" id="ai-upsell-search-btn" class="button"><?php esc_html_e( 'Search', 'ai-growth-suite' ); ?></button>
			</div>
		</div>
		<div class="ags-upsell-table-wrap">
			<table class="widefat fixed striped ags-upsell-table" id="ai-upsell-table">
				<thead>
					<tr>
						<th class="manage-column column-primary"><?php esc_html_e( 'Product', 'ai-growth-suite' ); ?></th>
						<th><?php esc_html_e( 'Suggested Upsells', 'ai-growth-suite' ); ?></th>
						<th><?php esc_html_e( 'Confidence Score', 'ai-growth-suite' ); ?></th>
						<th><?php esc_html_e( 'Status', 'ai-growth-suite' ); ?></th>
						<th><?php esc_html_e( 'Actions', 'ai-growth-suite' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php if ( empty( $recommendations ) ) : ?>
						<tr>
							<td colspan="5" class="ags-upsell-empty">
								<span class="dashicons dashicons-products"></span>
								<p><?php esc_html_e( 'No recommendations generated yet.', 'ai-growth-suite' ); ?></p>
								<p class="ags-empty-hint"><?php esc_html_e( 'Use "Force Regenerate All" to analyze products and create suggestions.', 'ai-growth-suite' ); ?></p>
							</td>
						</tr>
					<?php else : ?>
						<?php foreach ( $recommendations as $rec ) :
							$product = wc_get_product( $rec->product_id );
							if ( ! $product ) continue;
							$suggestions = json_decode( $rec->recommendations, true );
							?>
							<tr class="ai-upsell-row">
								<td class="column-primary product-name"><strong><?php echo esc_html( $product->get_name() ); ?></strong></td>
								<td class="suggestions-col">
									<?php
									if ( ! empty( $suggestions ) ) {
										foreach ( $suggestions as $s_id ) {
											$s_product = wc_get_product( $s_id );
											if ( $s_product ) {
												echo '<span class="ags-upsell-tag">' . esc_html( $s_product->get_name() ) . '</span>';
											}
										}
									}
									?>
								</td>
								<td><span class="ags-upsell-score">95%</span></td>
								<td><span class="ags-status ags-status-ok"><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e( 'Active', 'ai-growth-suite' ); ?></span></td>
								<td class="action-col">
									<button type="button" class="button button-small ai-edit-upsell-btn" data-id="<?php echo (int) $rec->product_id; ?>"><?php esc_html_e( 'Edit', 'ai-growth-suite' ); ?></button>
									<button type="button" class="button button-small button-link-delete ai-disable-upsell-btn" data-id="<?php echo (int) $rec->product_id; ?>"><?php esc_html_e( 'Disable', 'ai-growth-suite' ); ?></button>
								</td>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>
				</tbody>
			</table>
		</div>
	</div>

	<div class="card ags-upsell-card ags-upsell-config-card">
		<div class="ags-upsell-card-head">
			<h3><?php esc_html_e( 'Configuration', 'ai-growth-suite' ); ?></h3>
			<p class="ags-upsell-card-desc"><?php esc_html_e( 'Control auto-approval and where upsell blocks are displayed.', 'ai-growth-suite' ); ?></p>
		</div>
		<table class="form-table">
			<tr>
				<th scope="row"><?php esc_html_e( 'Auto-Approve', 'ai-growth-suite' ); ?></th>
				<td>
					<label class="switch">
						<input type="checkbox" checked>
						<span class="slider round"></span>
					</label>
					<span class="description"><?php esc_html_e( 'Automatically approve suggestions with >90% confidence.', 'ai-growth-suite' ); ?></span>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Display Locations', 'ai-growth-suite' ); ?></th>
				<td>
					<label><input type="checkbox" checked> <?php esc_html_e( 'Product Page', 'ai-growth-suite' ); ?></label><br>
					<label><input type="checkbox" checked> <?php esc_html_e( 'Cart Page', 'ai-growth-suite' ); ?></label><br>
					<label><input type="checkbox" checked> <?php esc_html_e( 'Checkout Page', 'ai-growth-suite' ); ?></label>
				</td>
			</tr>
		</table>
		<p class="submit">
			<button type="button" class="button button-primary"><?php esc_html_e( 'Save Changes', 'ai-growth-suite' ); ?></button>
		</p>
	</div>
</div>
