<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$is_pro = class_exists( 'AI_Growth_Suite_License_Manager' ) && AI_Growth_Suite_License_Manager::is_pro_active();
?>
<div class="ai-growth-suite-upgrade">
	<div style="text-align: center; margin-bottom: 40px;">
		<h2 style="font-size: 2.5rem; margin-bottom: 10px;"><?php esc_html_e( 'Upgrade to PRO', 'ai-growth-suite' ); ?></h2>
		<p style="font-size: 1.2rem; color: var(--ai-text-muted);"><?php esc_html_e( 'Unlock the full power of AI for your store and skyrocket your sales.', 'ai-growth-suite' ); ?></p>
	</div>

	<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; max-width: 900px; margin: 0 auto;">
		<!-- Free Plan -->
		<div class="card" style="border-top: 4px solid var(--ai-text-muted);">
			<h3 style="text-align: center; border-bottom: none;"><?php esc_html_e( 'Free', 'ai-growth-suite' ); ?></h3>
			<div style="text-align: center; font-size: 2rem; font-weight: bold; margin-bottom: 20px;">$0 <span style="font-size: 1rem; font-weight: normal; color: var(--ai-text-muted);">/ <?php esc_html_e( 'month', 'ai-growth-suite' ); ?></span></div>
			<ul style="list-style: none; padding: 0; margin: 0 0 30px 0;">
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Basic Product Descriptions', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Standard Upsells', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px; color: var(--ai-text-muted);">&#10007; <?php esc_html_e( 'A/B Testing for titles & descriptions', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px; color: var(--ai-text-muted);">&#10007; <?php esc_html_e( 'Advanced Analytics dashboard', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px; color: var(--ai-text-muted);">&#10007; <?php esc_html_e( 'Unlimited AI content generation', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px; color: var(--ai-text-muted);">&#10007; <?php esc_html_e( 'Automatic plugin updates', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px; color: var(--ai-text-muted);">&#10007; <?php esc_html_e( 'Priority email support', 'ai-growth-suite' ); ?></li>
			</ul>
			<button class="button button-secondary" style="width: 100%;" disabled><?php echo $is_pro ? esc_html__( 'Free Plan', 'ai-growth-suite' ) : esc_html__( 'Current Plan', 'ai-growth-suite' ); ?></button>
		</div>

		<!-- PRO Plan -->
		<div class="card" style="border-top: 4px solid var(--ai-primary); transform: scale(1.05); box-shadow: 0 10px 25px rgba(0,0,0,0.1);">
			<h3 style="text-align: center; border-bottom: none; color: var(--ai-primary);"><?php esc_html_e( 'PRO', 'ai-growth-suite' ); ?></h3>
			<div style="text-align: center; font-size: 2rem; font-weight: bold; margin-bottom: 20px;">$49 <span style="font-size: 1rem; font-weight: normal; color: var(--ai-text-muted);">/ <?php esc_html_e( 'month', 'ai-growth-suite' ); ?></span></div>
			<ul style="list-style: none; padding: 0; margin: 0 0 30px 0;">
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Basic Product Descriptions', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Standard Upsells', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'A/B Testing for titles & descriptions', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Advanced Analytics dashboard', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Unlimited AI content generation', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Automatic plugin updates', 'ai-growth-suite' ); ?></li>
				<li style="margin-bottom: 10px;">&#10003; <?php esc_html_e( 'Priority email support', 'ai-growth-suite' ); ?></li>
			</ul>
			<?php if ( $is_pro ) : ?>
				<span class="button button-secondary" style="width: 100%; display: block; text-align: center; padding: 12px 0; cursor: default;"><?php esc_html_e( 'Current Plan', 'ai-growth-suite' ); ?></span>
			<?php else : ?>
				<a href="https://plugins.assertivlogix.com/plugin/ai-ecommerce-growth-suite/" class="button button-primary" style="width: 100%; display: block; text-align: center; padding: 12px 0;"><?php esc_html_e( 'Buy PRO Now', 'ai-growth-suite' ); ?></a>
			<?php endif; ?>
		</div>
	</div>
</div>
