<div class="ai-growth-suite-settings">
	<h2><?php esc_html_e( 'Settings', 'ai-growth-suite' ); ?></h2>

	<?php if ( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] === 'true' ) : ?>
		<div class="notice notice-success is-dismissible"><p><?php esc_html_e( 'Settings saved.', 'ai-growth-suite' ); ?></p></div>
	<?php endif; ?>

	<div class="card">
		<h3><?php esc_html_e( 'General Configuration', 'ai-growth-suite' ); ?></h3>
		<form method="post" action="<?php echo esc_url( admin_url( 'options.php' ) ); ?>">
			<?php settings_fields( 'ai_growth_suite_options' ); ?>
			<?php do_settings_sections( 'ai_growth_suite_options' ); ?>

			<table class="form-table">
				<tr valign="top">
					<th scope="row"><label for="ai_growth_suite_api_key"><?php esc_html_e( 'AI API Key', 'ai-growth-suite' ); ?></label></th>
					<td>
						<input type="password" id="ai_growth_suite_api_key" name="ai_growth_suite_api_key" value="<?php echo esc_attr( get_option( 'ai_growth_suite_api_key', '' ) ); ?>" class="regular-text" autocomplete="off" />
						<p class="description"><?php esc_html_e( 'Enter your OpenAI or other provider API key here.', 'ai-growth-suite' ); ?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row"><?php esc_html_e( 'Enable Dynamic Pricing Globally', 'ai-growth-suite' ); ?></th>
					<td>
						<label class="switch">
							<input type="hidden" name="ai_growth_suite_dynamic_pricing_enabled" value="0" />
							<input type="checkbox" name="ai_growth_suite_dynamic_pricing_enabled" value="1" <?php checked( (int) get_option( 'ai_growth_suite_dynamic_pricing_enabled', 0 ), 1 ); ?> />
							<span class="slider round"></span>
						</label>
						<p class="description"><?php esc_html_e( 'Master switch to enable/disable all dynamic pricing rules.', 'ai-growth-suite' ); ?></p>
					</td>
				</tr>
			</table>

			<p class="submit">
				<?php submit_button( __( 'Save Settings', 'ai-growth-suite' ), 'primary', 'submit', false ); ?>
			</p>
		</form>
	</div>
</div>

<style>
/* Toggle Switch CSS */
.switch {
  position: relative;
  display: inline-block;
  width: 40px;
  height: 24px;
}
.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}
.slider:before {
  position: absolute;
  content: "";
  height: 16px;
  width: 16px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}
input:checked + .slider {
  background-color: var(--ai-primary);
}
input:focus + .slider {
  box-shadow: 0 0 1px var(--ai-primary);
}
input:checked + .slider:before {
  -webkit-transform: translateX(16px);
  -ms-transform: translateX(16px);
  transform: translateX(16px);
}
.slider.round {
  border-radius: 34px;
}
.slider.round:before {
  border-radius: 50%;
}
</style>
