<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$paged = isset( $_GET['paged'] ) ? max( 1, intval( $_GET['paged'] ) ) : 1;
$args = array(
	'limit'  => 10,
	'page'   => $paged,
	'paginate' => true,
);

if ( isset( $_POST['filter_cat'] ) && $_POST['filter_cat'] !== '0' ) {
	$args['category'] = array( sanitize_text_field( $_POST['filter_cat'] ) );
}

$products_query = wc_get_products( $args );
$products       = $products_query->products;
$total_pages    = $products_query->max_num_pages;
$categories     = get_terms( 'product_cat', array( 'hide_empty' => false ) );

$optimized_count = 0;
foreach ( $products as $p ) {
	if ( get_post_meta( $p->get_id(), '_ai_optimized', true ) ) {
		$optimized_count++;
	}
}
$filter_cat = isset( $_POST['filter_cat'] ) ? $_POST['filter_cat'] : '';
?>
<div class="ai-growth-suite-product-ai ags-product-ai">
	<!-- Hero -->
	<div class="ags-product-ai-hero">
		<div class="ags-product-ai-hero-bg"></div>
		<div class="ags-product-ai-hero-inner">
			<div class="ags-product-ai-hero-icon">
				<svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 3a6 6 0 0 0 9 9 9 9 0 1 1-9-9Z"/><path d="M12 8v4"/><path d="M12 16h.01"/></svg>
			</div>
			<h1 class="ags-product-ai-hero-title"><?php esc_html_e( 'Product AI Tools', 'ai-growth-suite' ); ?></h1>
			<p class="ags-product-ai-hero-desc"><?php esc_html_e( 'Generate SEO-optimized descriptions and short descriptions for your products using AI. Select products and run Generate or use Generate All for the current page.', 'ai-growth-suite' ); ?></p>
			<div class="ags-product-ai-hero-actions">
				<button type="button" class="button button-primary"><?php esc_html_e( 'Generate All Descriptions', 'ai-growth-suite' ); ?></button>
			</div>
		</div>
	</div>

	<div class="ags-product-ai-stats">
		<div class="ags-product-ai-stat-card">
			<span class="ags-product-ai-stat-icon ags-product-ai-stat-icon-page">
				<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2"/><path d="M3 9h18"/><path d="M9 21V9"/></svg>
			</span>
			<div class="ags-product-ai-stat-body">
				<h4><?php esc_html_e( 'On this page', 'ai-growth-suite' ); ?></h4>
				<div class="value"><?php echo count( $products ); ?></div>
				<p class="stat-desc"><?php esc_html_e( 'products', 'ai-growth-suite' ); ?></p>
			</div>
		</div>
		<div class="ags-product-ai-stat-card">
			<span class="ags-product-ai-stat-icon ags-product-ai-stat-icon-ok">
				<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><path d="m9 11 3 3L22 4"/></svg>
			</span>
			<div class="ags-product-ai-stat-body">
				<h4><?php esc_html_e( 'AI Optimized', 'ai-growth-suite' ); ?></h4>
				<div class="value"><?php echo (int) $optimized_count; ?></div>
				<p class="stat-desc"><?php esc_html_e( 'on this page', 'ai-growth-suite' ); ?></p>
			</div>
		</div>
	</div>

	<div class="card ags-product-ai-card">
		<div class="ags-product-ai-card-head">
			<h3><?php esc_html_e( 'Bulk Generator', 'ai-growth-suite' ); ?></h3>
			<p class="ags-product-ai-card-desc"><?php esc_html_e( 'Generate or regenerate content per product, or use bulk actions. Filter by category to focus on specific products.', 'ai-growth-suite' ); ?></p>
		</div>

		<form method="post" action="">
			<div class="ags-product-ai-toolbar tablenav top">
				<div class="ags-toolbar-group">
					<select name="action" id="bulk-action-selector-top" class="ags-select">
						<option value="-1"><?php esc_html_e( 'Bulk Actions', 'ai-growth-suite' ); ?></option>
						<option value="generate"><?php esc_html_e( 'Generate Content', 'ai-growth-suite' ); ?></option>
						<option value="regenerate"><?php esc_html_e( 'Regenerate Content', 'ai-growth-suite' ); ?></option>
					</select>
					<button type="submit" id="doaction" class="button action"><?php esc_html_e( 'Apply', 'ai-growth-suite' ); ?></button>
				</div>
				<div class="ags-toolbar-group">
					<select name="filter_cat" id="filter_cat" class="ags-select">
						<option value="0"><?php esc_html_e( 'All categories', 'ai-growth-suite' ); ?></option>
						<?php foreach ( $categories as $cat ) : ?>
							<option value="<?php echo esc_attr( $cat->slug ); ?>" <?php selected( $filter_cat, $cat->slug ); ?>><?php echo esc_html( $cat->name ); ?></option>
						<?php endforeach; ?>
					</select>
					<button type="submit" name="filter_action" id="post-query-submit" class="button"><?php esc_html_e( 'Filter', 'ai-growth-suite' ); ?></button>
				</div>
			</div>

			<div class="ags-product-ai-table-wrap">
				<table class="widefat striped ags-product-ai-table">
					<thead>
						<tr>
							<th scope="col" class="manage-column column-cb check-column"><input type="checkbox" class="ags-check-all" aria-label="<?php esc_attr_e( 'Select all', 'ai-growth-suite' ); ?>" /></th>
							<th scope="col" class="manage-column column-primary"><?php esc_html_e( 'Product', 'ai-growth-suite' ); ?></th>
							<th scope="col"><?php esc_html_e( 'Category', 'ai-growth-suite' ); ?></th>
							<th scope="col"><?php esc_html_e( 'AI Status', 'ai-growth-suite' ); ?></th>
							<th scope="col"><?php esc_html_e( 'Last optimized', 'ai-growth-suite' ); ?></th>
							<th scope="col"><?php esc_html_e( 'Action', 'ai-growth-suite' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php if ( empty( $products ) ) : ?>
							<tr>
								<td colspan="6" class="ags-empty-row">
									<span class="dashicons dashicons-admin-page"></span>
									<p><?php esc_html_e( 'No products found.', 'ai-growth-suite' ); ?></p>
									<p class="ags-empty-hint"><?php esc_html_e( 'Add products in WooCommerce or change the filter.', 'ai-growth-suite' ); ?></p>
								</td>
							</tr>
						<?php else : ?>
							<?php foreach ( $products as $product ) :
								$is_optimized  = get_post_meta( $product->get_id(), '_ai_optimized', true );
								$last_optimized = get_post_meta( $product->get_id(), '_ai_last_optimized', true );
								?>
								<tr>
									<th scope="row" class="check-column"><input type="checkbox" name="product_ids[]" value="<?php echo (int) $product->get_id(); ?>" /></th>
									<td class="column-primary product-name">
										<strong><?php echo esc_html( $product->get_name() ); ?></strong>
									</td>
									<td class="product-categories"><?php echo wp_kses_post( wc_get_product_category_list( $product->get_id() ) ); ?></td>
									<td class="ai-status">
										<?php if ( $is_optimized ) : ?>
											<span class="ags-status ags-status-ok"><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e( 'Optimized', 'ai-growth-suite' ); ?></span>
										<?php else : ?>
											<span class="ags-status ags-status-pending"><span class="dashicons dashicons-edit"></span> <?php esc_html_e( 'Pending', 'ai-growth-suite' ); ?></span>
										<?php endif; ?>
									</td>
									<td class="last-optimized"><?php echo $last_optimized ? esc_html( wp_date( 'M j, Y', strtotime( $last_optimized ) ) ) : '—'; ?></td>
									<td class="action-col">
										<button type="button" class="button button-small ai-generate-btn" data-id="<?php echo (int) $product->get_id(); ?>">
											<?php echo $is_optimized ? esc_html__( 'Regenerate', 'ai-growth-suite' ) : esc_html__( 'Generate', 'ai-growth-suite' ); ?>
										</button>
									</td>
								</tr>
							<?php endforeach; ?>
						<?php endif; ?>
					</tbody>
				</table>
			</div>

			<?php if ( $total_pages > 1 ) : ?>
				<div class="ags-product-ai-pagination tablenav bottom">
					<div class="tablenav-pages">
						<?php
						echo paginate_links( array(
							'base'    => add_query_arg( 'paged', '%#%' ),
							'format'  => '',
							'current' => $paged,
							'total'   => $total_pages,
							'prev_text' => '&larr;',
							'next_text' => '&rarr;',
						) );
						?>
					</div>
				</div>
			<?php endif; ?>
		</form>
	</div>
</div>
