<?php
global $wpdb;
$table_log = $wpdb->prefix . 'ai_email_log';

$total_sent = 0;
$total_failed = 0;
if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'ai_email_log' ) ) {
	$total_sent = (int) $wpdb->get_var( "SELECT COUNT(*) FROM $table_log WHERE status = 'sent'" );
	$total_failed = (int) $wpdb->get_var( "SELECT COUNT(*) FROM $table_log WHERE status = 'failed'" );
}
$open_rate = '0%';
$click_rate = '0%';

$active_tab = isset( $_GET['tab'] ) ? sanitize_text_field( $_GET['tab'] ) : 'flows';
?>
<div class="ai-growth-suite-marketing">
	<h2>Marketing Automation</h2>
	<p style="margin-bottom: 20px; color: var(--ai-text-muted);">Automate your email marketing with AI-generated content that adapts to your brand tone.</p>

	<!-- Tabs Navigation -->
	<h2 class="nav-tab-wrapper" style="margin-bottom: 20px;">
		<a href="?page=ai-growth-suite-marketing&tab=flows" class="nav-tab <?php echo $active_tab === 'flows' ? 'nav-tab-active' : ''; ?>">
			Email Flows
		</a>
		<a href="?page=ai-growth-suite-marketing&tab=log" class="nav-tab <?php echo $active_tab === 'log' ? 'nav-tab-active' : ''; ?>">
			Email Log
			<?php if ( $total_failed > 0 ) : ?>
			<span class="awaiting-mod count-<?php echo $total_failed; ?>" style="background: #d63638; margin-left: 5px;">
				<span class="pending-count"><?php echo $total_failed; ?></span>
			</span>
			<?php endif; ?>
		</a>
		<a href="?page=ai-growth-suite-marketing&tab=settings" class="nav-tab <?php echo $active_tab === 'settings' ? 'nav-tab-active' : ''; ?>">
			Settings
		</a>
	</h2>

	<?php if ( $active_tab === 'flows' ) : ?>
	<!-- Email Flows Tab -->

	<div class="card">
		<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
			<h3 style="margin: 0;">Email Flows</h3>
			<button type="button" id="ai-create-flow-btn" class="button button-primary">Create New Flow</button>
		</div>
		<table class="widefat fixed striped">
			<thead>
				<tr>
					<th class="manage-column column-primary">Flow Name</th>
					<th>Trigger</th>
					<th>AI Tone</th>
					<th>Status</th>
					<th>Actions</th>
				</tr>
			</thead>
			<tbody>
				<?php
				$flows_table = $wpdb->prefix . 'email_flows';
				$flows = array();
				if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'email_flows' ) ) {
					$flows = $wpdb->get_results( "SELECT * FROM $flows_table ORDER BY created_at DESC" );
					if ( ! is_array( $flows ) ) {
						$flows = array();
					}
				}
				if ( empty( $flows ) ) {
					// Show default flows if none exist
					$default_flows = array(
						array(
							'flow_name' => 'Welcome Series',
							'flow_slug' => 'welcome',
							'trigger_type' => 'New User Registration',
							'ai_tone' => 'Friendly',
							'is_active' => 1
						),
						array(
							'flow_name' => 'Post-Purchase Upsell',
							'flow_slug' => 'post_purchase',
							'trigger_type' => 'Order Completed',
							'ai_tone' => 'Professional',
							'is_active' => 1
						),
						array(
							'flow_name' => 'Win-Back',
							'flow_slug' => 'win_back',
							'trigger_type' => 'Inactive for 30 days',
							'ai_tone' => 'Humorous',
							'is_active' => 0
						)
					);
					$flows = array_map(function($f) { return (object) $f; }, $default_flows);
				}
				
				foreach ( $flows as $flow ) :
					$status_icon = $flow->is_active ? 'dashicons-yes' : 'dashicons-no';
					$status_color = $flow->is_active ? 'var(--ai-success)' : 'var(--ai-text-muted)';
					$status_text = $flow->is_active ? 'Active' : 'Inactive';
					$flow_id = isset( $flow->id ) ? $flow->id : 0;
				?>
				<tr>
					<td class="column-primary"><strong><?php echo esc_html( $flow->flow_name ); ?></strong></td>
					<td><?php echo esc_html( $flow->trigger_type ); ?></td>
					<td><?php echo esc_html( $flow->ai_tone ); ?></td>
					<td>
						<?php if ( $flow_id > 0 ) : ?>
						<label class="ai-toggle-switch" style="display: inline-block; vertical-align: middle;">
							<input type="checkbox" class="ai-toggle-flow-status" data-id="<?php echo $flow_id; ?>" <?php checked( $flow->is_active, 1 ); ?>>
							<span class="ai-toggle-slider"></span>
						</label>
						<span style="margin-left: 8px; vertical-align: middle;"><?php echo $status_text; ?></span>
						<?php else : ?>
						<span class="dashicons <?php echo $status_icon; ?>" style="color: <?php echo $status_color; ?>;"></span> <?php echo $status_text; ?>
						<?php endif; ?>
					</td>
					<td>
						<button class="button button-small ai-edit-template-btn" data-flow="<?php echo esc_attr( $flow->flow_slug ); ?>">Edit Template</button>
						<?php if ( $flow_id > 0 ) : ?>
						<button class="button button-small button-link-delete ai-delete-flow-btn" data-id="<?php echo $flow_id; ?>" style="color: var(--ai-danger);">Delete</button>
						<?php endif; ?>
					</td>
				</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>

	<div class="card">
		<h3>Global AI Settings</h3>
		<p style="color: var(--ai-text-muted); margin-bottom: 20px;">
			Configure how AI generates email content across all your email flows. These settings apply globally to all automated emails.
		</p>
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="ai-marketing-tone">Brand Tone</label>
				</th>
				<td>
					<select id="ai-marketing-tone" style="max-width: 300px;">
						<option value="Professional" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Professional' ); ?>>Professional</option>
						<option value="Friendly" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Friendly' ); ?>>Friendly</option>
						<option value="Humorous" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Humorous' ); ?>>Humorous</option>
						<option value="Luxury" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Luxury' ); ?>>Luxury</option>
					</select>
					<p class="description">
						<strong>What this does:</strong> Sets the writing style for all AI-generated email content.<br>
						<strong>Examples:</strong><br>
						• <strong>Professional:</strong> "Thank you for your purchase. We appreciate your business."<br>
						• <strong>Friendly:</strong> "Hey there! Thanks so much for your order! 😊"<br>
						• <strong>Humorous:</strong> "Woohoo! Your order is on its way (faster than a caffeinated cheetah)!"<br>
						• <strong>Luxury:</strong> "We are delighted to serve you with our premium collection."
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>Sending Domain</label>
				</th>
				<td>
					<input type="text" value="<?php echo esc_attr( parse_url( site_url(), PHP_URL_HOST ) ); ?>" class="regular-text" readonly style="background: #f5f5f5;">
					<p class="description">
						<strong>What this is:</strong> The domain name used to send emails from your store.<br>
						<strong>Note:</strong> This is automatically detected from your WordPress site URL. To change it, update your site settings or configure WP Mail SMTP plugin.
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>Email Personalization</label>
				</th>
				<td>
					<p class="description" style="margin: 0;">
						<strong>Available Tokens:</strong> Use these placeholders in your email templates:<br>
						• <code>{name}</code> - Customer's name<br>
						• <code>{store_name}</code> - Your store name<br>
						• <code>{order_total}</code> - Order total amount (for order-related emails)<br>
						<br>
						<strong>Example:</strong> "Hi {name}, thank you for shopping at {store_name}!"
					</p>
				</td>
			</tr>
		</table>
		<p class="submit">
			<button type="button" id="ai-save-marketing-settings-btn" class="button button-primary">Save Settings</button>
			<span class="description" style="margin-left: 10px;">Changes will apply to all future AI-generated emails.</span>
		</p>
	</div>

	<!-- Create Flow Modal -->
	<div id="ai-create-flow-modal" style="display:none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999; align-items: center; justify-content: center;">
		<div style="background: #fff; padding: 30px; border-radius: 8px; width: 600px; max-width: 90%; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
			<h3 style="margin-top: 0;">Create New Email Flow</h3>
			
			<p>
				<label style="font-weight: bold; display: block; margin-bottom: 5px;">Flow Name</label>
				<input type="text" id="ai-new-flow-name" class="regular-text" style="width: 100%;" placeholder="e.g. Birthday Discount">
				<span class="description">Give your email flow a descriptive name</span>
			</p>
			<p>
				<label style="font-weight: bold; display: block; margin-bottom: 5px;">Trigger Type</label>
				<select id="ai-new-flow-trigger" style="width: 100%;">
					<option value="">-- Select a Trigger --</option>
					<optgroup label="Customer Events">
						<option value="New User Registration">New User Registration</option>
						<option value="Customer Birthday">Customer Birthday</option>
						<option value="First Purchase">First Purchase</option>
						<option value="Repeat Purchase">Repeat Purchase</option>
					</optgroup>
					<optgroup label="Order Events">
						<option value="Order Completed">Order Completed</option>
						<option value="Order Shipped">Order Shipped</option>
						<option value="Order Delivered">Order Delivered</option>
						<option value="Order Cancelled">Order Cancelled</option>
					</optgroup>
					<optgroup label="Engagement">
						<option value="Inactive for 7 days">Inactive for 7 days</option>
						<option value="Inactive for 30 days">Inactive for 30 days</option>
						<option value="Inactive for 60 days">Inactive for 60 days</option>
						<option value="Inactive for 90 days">Inactive for 90 days</option>
					</optgroup>
					<optgroup label="Cart Events">
						<option value="Cart Abandoned">Cart Abandoned</option>
						<option value="Cart Recovered">Cart Recovered</option>
					</optgroup>
					<optgroup label="Product Events">
						<option value="Product Review Request">Product Review Request</option>
						<option value="Product Back in Stock">Product Back in Stock</option>
						<option value="Product Price Drop">Product Price Drop</option>
					</optgroup>
					<optgroup label="Custom">
						<option value="custom">Custom Trigger (Manual)</option>
					</optgroup>
				</select>
				<span class="description">When should this email be sent?</span>
			</p>
			<p id="ai-custom-trigger-wrapper" style="display: none;">
				<label style="font-weight: bold; display: block; margin-bottom: 5px;">Custom Trigger Description</label>
				<input type="text" id="ai-custom-trigger-text" class="regular-text" style="width: 100%;" placeholder="Describe your custom trigger">
			</p>
			<p>
				<label style="font-weight: bold; display: block; margin-bottom: 5px;">AI Tone</label>
				<select id="ai-new-flow-tone" style="width: 100%;">
					<option value="Professional">Professional</option>
					<option value="Friendly" selected>Friendly</option>
					<option value="Humorous">Humorous</option>
					<option value="Luxury">Luxury</option>
				</select>
				<span class="description">Writing style for this email flow</span>
			</p>
			
			<div style="text-align: right; margin-top: 20px;">
				<button type="button" class="button button-secondary" onclick="document.getElementById('ai-create-flow-modal').style.display='none'">Cancel</button>
				<button type="button" id="ai-save-flow-btn" class="button button-primary">Create Flow</button>
			</div>
		</div>
	</div>

<?php endif; ?>

<?php if ( $active_tab === 'log' ) : ?>
<!-- Email Log Tab -->
<div class="card">
	<h3>Email Log</h3>
	<p style="color: var(--ai-text-muted); margin-bottom: 20px;">
		View all sent and failed emails. Monitor delivery status and troubleshoot issues.
	</p>

	<div class="stats-grid" style="grid-template-columns: repeat(3, 1fr); margin-bottom: 20px;">
		<div class="stat-card">
			<h4>Total Sent</h4>
			<div class="value" style="color: var(--ai-success);"><?php echo intval( $total_sent ); ?></div>
		</div>
		<div class="stat-card">
			<h4>Failed</h4>
			<div class="value" style="color: var(--ai-danger);"><?php echo intval( $total_failed ); ?></div>
		</div>
		<div class="stat-card">
			<h4>Success Rate</h4>
			<div class="value">
				<?php 
				$total = $total_sent + $total_failed;
				$rate = $total > 0 ? round(($total_sent / $total) * 100, 1) : 100;
				echo $rate . '%';
				?>
			</div>
		</div>
	</div>

	<table class="widefat fixed striped">
		<thead>
			<tr>
				<th class="manage-column">Date</th>
				<th class="manage-column">Recipient</th>
				<th class="manage-column">Subject</th>
				<th class="manage-column">Type</th>
				<th class="manage-column">Status</th>
			</tr>
		</thead>
		<tbody>
			<?php
			$logs = $wpdb->get_results( "SELECT * FROM $table_log ORDER BY sent_at DESC LIMIT 50" );
			if ( empty( $logs ) ) :
			?>
			<tr>
				<td colspan="5" style="text-align: center; padding: 40px; color: var(--ai-text-muted);">
					<span class="dashicons dashicons-email" style="font-size: 48px; opacity: 0.3;"></span>
					<p style="margin-top: 10px;">No emails sent yet. Emails will appear here once your flows are triggered.</p>
				</td>
			</tr>
			<?php else : ?>
			<?php foreach ( $logs as $log ) : 
				$status_class = $log->status === 'sent' ? 'success' : 'danger';
				$status_icon = $log->status === 'sent' ? 'dashicons-yes' : 'dashicons-no';
			?>
			<tr>
				<td><?php echo esc_html( date( 'M d, Y H:i', strtotime( $log->sent_at ) ) ); ?></td>
				<td><?php echo esc_html( $log->email_to ); ?></td>
				<td><strong><?php echo esc_html( $log->email_subject ); ?></strong></td>
				<td><span class="description"><?php echo esc_html( ucfirst( str_replace( '_', ' ', $log->email_type ) ) ); ?></span></td>
				<td>
					<span class="dashicons <?php echo $status_icon; ?>" style="color: var(--ai-<?php echo $status_class; ?>);"></span>
					<?php echo ucfirst( $log->status ); ?>
				</td>
			</tr>
			<?php endforeach; ?>
			<?php endif; ?>
		</tbody>
	</table>
</div>
<?php endif; ?>

<?php if ( $active_tab === 'settings' ) : ?>
<!-- Settings Tab -->
<div class="card">
	<h3>Global AI Settings</h3>
	<p style="color: var(--ai-text-muted); margin-bottom: 20px;">
		Configure how AI generates email content across all your email flows. These settings apply globally to all automated emails.
	</p>
	<table class="form-table">
		<tr>
			<th scope="row">
				<label for="ai-marketing-tone">Brand Tone</label>
			</th>
			<td>
				<select id="ai-marketing-tone" style="max-width: 300px;">
					<option value="Professional" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Professional' ); ?>>Professional</option>
					<option value="Friendly" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Friendly' ); ?>>Friendly</option>
					<option value="Humorous" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Humorous' ); ?>>Humorous</option>
					<option value="Luxury" <?php selected( get_option( 'ai_growth_suite_brand_tone' ), 'Luxury' ); ?>>Luxury</option>
				</select>
				<p class="description">
					<strong>What this does:</strong> Sets the writing style for all AI-generated email content.<br>
					<strong>Examples:</strong><br>
					• <strong>Professional:</strong> "Thank you for your purchase. We appreciate your business."<br>
					• <strong>Friendly:</strong> "Hey there! Thanks so much for your order! 😊"<br>
					• <strong>Humorous:</strong> "Woohoo! Your order is on its way (faster than a caffeinated cheetah)!"<br>
					• <strong>Luxury:</strong> "We are delighted to serve you with our premium collection."
				</p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label>Sending Domain</label>
			</th>
			<td>
				<input type="text" value="<?php echo esc_attr( parse_url( site_url(), PHP_URL_HOST ) ); ?>" class="regular-text" readonly style="background: #f5f5f5;">
				<p class="description">
					<strong>What this is:</strong> The domain name used to send emails from your store.<br>
					<strong>Note:</strong> This is automatically detected from your WordPress site URL. To change it, update your site settings or configure WP Mail SMTP plugin.
				</p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label>Email Personalization</label>
			</th>
			<td>
				<p class="description" style="margin: 0;">
					<strong>Available Tokens:</strong> Use these placeholders in your email templates:<br>
					• <code>{name}</code> - Customer's name<br>
					• <code>{store_name}</code> - Your store name<br>
					• <code>{order_total}</code> - Order total amount (for order-related emails)<br>
					<br>
					<strong>Example:</strong> "Hi {name}, thank you for shopping at {store_name}!"
				</p>
			</td>
		</tr>
	</table>
	<p class="submit">
		<button type="button" id="ai-save-marketing-settings-btn" class="button button-primary">Save Settings</button>
		<span class="description" style="margin-left: 10px;">Changes will apply to all future AI-generated emails.</span>
	</p>
</div>
<?php endif; ?>

<!-- Create Flow Modal -->
<div id="ai-create-flow-modal" style="display:none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999; align-items: center; justify-content: center;">
	<div style="background: #fff; padding: 30px; border-radius: 8px; width: 600px; max-width: 90%; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
		<h3 style="margin-top: 0;">Create New Email Flow</h3>
		
		<p>
			<label style="font-weight: bold; display: block; margin-bottom: 5px;">Flow Name</label>
			<input type="text" id="ai-new-flow-name" class="regular-text" style="width: 100%;" placeholder="e.g. Birthday Discount">
			<span class="description">Give your email flow a descriptive name</span>
		</p>
		<p>
			<label style="font-weight: bold; display: block; margin-bottom: 5px;">Trigger Type</label>
			<select id="ai-new-flow-trigger" style="width: 100%;">
				<option value="">-- Select a Trigger --</option>
				<optgroup label="Customer Events">
					<option value="New User Registration">New User Registration</option>
					<option value="Customer Birthday">Customer Birthday</option>
					<option value="First Purchase">First Purchase</option>
					<option value="Repeat Purchase">Repeat Purchase</option>
				</optgroup>
				<optgroup label="Order Events">
					<option value="Order Completed">Order Completed</option>
					<option value="Order Shipped">Order Shipped</option>
					<option value="Order Delivered">Order Delivered</option>
					<option value="Order Cancelled">Order Cancelled</option>
				</optgroup>
				<optgroup label="Engagement">
					<option value="Inactive for 7 days">Inactive for 7 days</option>
					<option value="Inactive for 30 days">Inactive for 30 days</option>
					<option value="Inactive for 60 days">Inactive for 60 days</option>
					<option value="Inactive for 90 days">Inactive for 90 days</option>
				</optgroup>
				<optgroup label="Cart Events">
					<option value="Cart Abandoned">Cart Abandoned</option>
					<option value="Cart Recovered">Cart Recovered</option>
				</optgroup>
				<optgroup label="Product Events">
					<option value="Product Review Request">Product Review Request</option>
					<option value="Product Back in Stock">Product Back in Stock</option>
					<option value="Product Price Drop">Product Price Drop</option>
				</optgroup>
				<optgroup label="Custom">
					<option value="custom">Custom Trigger (Manual)</option>
				</optgroup>
			</select>
			<span class="description">When should this email be sent?</span>
		</p>
		<p id="ai-custom-trigger-wrapper" style="display: none;">
			<label style="font-weight: bold; display: block; margin-bottom: 5px;">Custom Trigger Description</label>
			<input type="text" id="ai-custom-trigger-text" class="regular-text" style="width: 100%;" placeholder="Describe your custom trigger">
		</p>
		<p>
			<label style="font-weight: bold; display: block; margin-bottom: 5px;">AI Tone</label>
			<select id="ai-new-flow-tone" style="width: 100%;">
				<option value="Professional">Professional</option>
				<option value="Friendly" selected>Friendly</option>
				<option value="Humorous">Humorous</option>
				<option value="Luxury">Luxury</option>
			</select>
			<span class="description">Writing style for this email flow</span>
		</p>
		
		<div style="text-align: right; margin-top: 20px;">
			<button type="button" class="button button-secondary" onclick="document.getElementById('ai-create-flow-modal').style.display='none'">Cancel</button>
			<button type="button" id="ai-save-flow-btn" class="button button-primary">Create Flow</button>
		</div>
	</div>
</div>

<!-- Edit Template Modal -->
<div id="ai-template-modal" style="display:none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999; align-items: center; justify-content: center;">
	<div style="background: #fff; border-radius: 8px; width: 700px; max-width: 90%; max-height: 90vh; box-shadow: 0 4px 20px rgba(0,0,0,0.15); display: flex; flex-direction: column;">
		<!-- Modal Header -->
		<div style="padding: 20px 30px; border-bottom: 1px solid #ddd;">
			<h3 style="margin: 0;">Edit Email Template</h3>
		</div>

		<!-- Modal Body (Scrollable) -->
		<div style="padding: 20px 30px; overflow-y: auto; flex: 1;">
			<input type="hidden" id="ai-template-flow" value="">
			
			<!-- Template Content -->
			<div style="border-bottom: 1px solid #ddd; padding-bottom: 20px; margin-bottom: 20px;">
				<h4 style="margin-top: 0; color: #666;">Email Content</h4>
				<p>
					<label style="font-weight: bold; display: block; margin-bottom: 5px;">Subject Line</label>
					<input type="text" id="ai-template-subject" class="regular-text" style="width: 100%;">
				</p>
				<p>
					<label style="font-weight: bold; display: block; margin-bottom: 5px;">Email Body</label>
					<textarea id="ai-template-body" rows="6" style="width: 100%; font-family: monospace;"></textarea>
					<span class="description">
						<strong>Available Tokens:</strong> 
						{name}, {email}, {store_name}, {store_url}, {order_number}, {order_date}, {order_total}, 
						{order_items}, {order_url}, {product_name}, {product_url}, {shipping_address}, 
						{tracking_url}, {estimated_delivery}, {support_email}, {unsubscribe_url}, {recommended_products}, {offer_expiry}
					</span>
				</p>
			</div>

			<!-- Automation Settings -->
			<div style="border-bottom: 1px solid #ddd; padding-bottom: 20px; margin-bottom: 20px;">
				<h4 style="margin-top: 0; color: #666;">Automation Settings</h4>
				<p>
					<label style="font-weight: bold; display: block; margin-bottom: 5px;">
						<input type="checkbox" id="ai-template-auto-send" checked> 
						Send this email automatically
					</label>
					<span class="description">When disabled, emails will need to be sent manually.</span>
				</p>
				<div id="ai-template-timing-settings">
					<p>
						<label style="font-weight: bold; display: block; margin-bottom: 5px;">Send Timing</label>
						<select id="ai-template-send-timing" style="width: 100%; max-width: 400px;">
							<option value="immediate">Immediately when triggered</option>
							<option value="delay_minutes">After a delay (minutes)</option>
							<option value="delay_hours">After a delay (hours)</option>
							<option value="delay_days">After a delay (days)</option>
							<option value="specific_time">At a specific time of day</option>
						</select>
					</p>
					<p id="ai-template-delay-amount-wrapper" style="display: none;">
						<label style="font-weight: bold; display: block; margin-bottom: 5px;">Delay Amount</label>
						<input type="number" id="ai-template-delay-amount" min="1" value="1" style="width: 100px;">
						<span id="ai-template-delay-unit"></span>
						<span class="description" style="display: block; margin-top: 5px;">
							Example: Send 24 hours after order completion
						</span>
					</p>
					<p id="ai-template-specific-time-wrapper" style="display: none;">
						<label style="font-weight: bold; display: block; margin-bottom: 5px;">Time of Day</label>
						<input type="time" id="ai-template-specific-time" value="09:00" style="width: 150px;">
						<span class="description" style="display: block; margin-top: 5px;">
							Email will be sent at this time on the trigger day
						</span>
					</p>
				</div>
			</div>

			<!-- Preview Info -->
			<div style="background: #f0f6fc; padding: 15px; border-radius: 5px;">
				<strong style="color: #0969da;">💡 Pro Tip:</strong>
				<p style="margin: 5px 0 0 0; color: #666;">
					Test your email timing by creating a test order or user registration. Check the email log to verify delivery.
				</p>
			</div>
		</div>

		<!-- Modal Footer (Fixed) -->
		<div style="padding: 20px 30px; border-top: 2px solid #ddd; background: #fff; text-align: right; flex-shrink: 0;">
			<button type="button" class="button button-secondary" onclick="document.getElementById('ai-template-modal').style.display='none'" style="margin-right: 10px;">Cancel</button>
			<button type="button" id="ai-save-template-btn" class="button button-primary" style="min-width: 120px;">💾 Save Template</button>
		</div>
	</div>
</div>
</div>
