<?php
/**
 * License / Activation page for AI eCommerce Growth Suite.
 * Premium layout.
 *
 * @package AI_Growth_Suite
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$is_active = class_exists( 'AI_Growth_Suite_License_Manager' ) ? AI_Growth_Suite_License_Manager::is_pro_active() : false;
$masked    = class_exists( 'AI_Growth_Suite_License_Manager' ) ? AI_Growth_Suite_License_Manager::get_masked_key() : '';
$plan      = get_option( 'ai_growth_suite_license_plan', '' );
?>
<div class="ai-growth-suite-license ags-license-premium">
	<!-- Hero -->
	<div class="ags-license-hero">
		<div class="ags-license-hero-bg"></div>
		<span class="ags-license-pro-pill">PRO</span>
		<div class="ags-license-hero-inner">
			<div class="ags-license-hero-icon">
				<svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>
			</div>
			<h1 class="ags-license-hero-title"><?php esc_html_e( 'License & Activation', 'ai-growth-suite' ); ?></h1>
			<p class="ags-license-hero-desc"><?php esc_html_e( 'Unlock PRO features, receive automatic updates, and get priority support. Enter your license key below.', 'ai-growth-suite' ); ?></p>
			<p class="ags-license-hero-trust"><?php esc_html_e( 'Secure activation · One license per site', 'ai-growth-suite' ); ?></p>
		</div>
	</div>

	<div class="ags-license-grid">
		<div class="ags-license-main">
			<!-- Status -->
			<div class="ags-license-status-card <?php echo $is_active ? 'ags-license-active' : 'ags-license-inactive'; ?>">
				<div class="ags-license-status-inner">
					<span class="ags-license-status-dot"></span>
					<div class="ags-license-status-text">
						<strong><?php echo $is_active ? esc_html__( 'License Active', 'ai-growth-suite' ) : esc_html__( 'License Inactive', 'ai-growth-suite' ); ?></strong>
						<?php if ( $is_active && $plan ) : ?>
							<span class="ags-license-plan"><?php echo esc_html( ucfirst( $plan ) ); ?></span>
						<?php endif; ?>
					</div>
					<?php if ( $masked ) : ?>
						<code class="ags-license-key-code"><?php echo esc_html( $masked ); ?></code>
					<?php endif; ?>
				</div>
			</div>

			<!-- Form -->
			<div class="ags-license-form-card">
				<div class="ags-license-form-card-head">
					<h2 class="ags-license-form-title"><?php esc_html_e( 'Activate Your License', 'ai-growth-suite' ); ?></h2>
					<span class="ags-license-form-badge"><?php esc_html_e( 'Secure', 'ai-growth-suite' ); ?></span>
				</div>
				<form id="ai-license-form" class="ags-license-form">
					<input type="hidden" id="ai_growth_suite_license_nonce" value="<?php echo esc_attr( wp_create_nonce( 'ai_growth_suite_license_nonce' ) ); ?>" />
					<div class="ags-license-field">
						<label for="ai_growth_suite_license_key"><?php esc_html_e( 'License Key', 'ai-growth-suite' ); ?></label>
						<div class="ags-license-input-wrap">
							<input type="text" id="ai_growth_suite_license_key" placeholder="<?php esc_attr_e( 'XXXX-XXXX-XXXX-XXXX', 'ai-growth-suite' ); ?>" value="" autocomplete="off" />
							<span class="ags-license-input-icon"><svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/></svg></span>
						</div>
						<span class="ags-license-field-hint"><?php esc_html_e( 'Find your key in the purchase confirmation email or in your account dashboard.', 'ai-growth-suite' ); ?></span>
					</div>
					<div class="ags-license-actions">
						<button type="button" class="ags-license-btn ags-license-btn-activate" id="ai_growth_suite_activate_license">
							<svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M15 3h4a2 2 0 012 2v14a2 2 0 01-2 2h-4M10 17l5-5-5-5M15 12H3"/></svg>
							<?php esc_html_e( 'Activate License', 'ai-growth-suite' ); ?>
						</button>
						<?php if ( $is_active ) : ?>
							<button type="button" class="ags-license-btn ags-license-btn-deactivate" id="ai_growth_suite_deactivate_license">
								<?php esc_html_e( 'Deactivate', 'ai-growth-suite' ); ?>
							</button>
						<?php endif; ?>
						<span class="spinner" id="ai-license-spinner"></span>
					</div>
					<p id="ai-license-message" class="ags-license-message"></p>
				</form>
			</div>
		</div>

		<aside class="ags-license-sidebar">
			<div class="ags-license-benefits ags-license-free">
				<h3><?php esc_html_e( 'Included in Free', 'ai-growth-suite' ); ?></h3>
				<ul>
					<li><span class="ags-license-check"></span><?php esc_html_e( 'Basic Product Descriptions', 'ai-growth-suite' ); ?></li>
					<li><span class="ags-license-check"></span><?php esc_html_e( 'Standard Upsells', 'ai-growth-suite' ); ?></li>
				</ul>
			</div>
			<div class="ags-license-benefits">
				<h3><?php esc_html_e( 'Included in PRO', 'ai-growth-suite' ); ?></h3>
				<ul>
					<li><span class="ags-license-check"></span><?php esc_html_e( 'A/B Testing for titles & descriptions', 'ai-growth-suite' ); ?></li>
					<li><span class="ags-license-check"></span><?php esc_html_e( 'Advanced Analytics dashboard', 'ai-growth-suite' ); ?></li>
					<li><span class="ags-license-check"></span><?php esc_html_e( 'Unlimited AI content generation', 'ai-growth-suite' ); ?></li>
					<li><span class="ags-license-check"></span><?php esc_html_e( 'Automatic plugin updates', 'ai-growth-suite' ); ?></li>
					<li><span class="ags-license-check"></span><?php esc_html_e( 'Priority email support', 'ai-growth-suite' ); ?></li>
				</ul>
			</div>

			<div class="ags-license-cta">
				<p><?php esc_html_e( "Don't have a license?", 'ai-growth-suite' ); ?></p>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=ai-growth-suite-upgrade' ) ); ?>" class="ags-license-cta-link"><?php esc_html_e( 'View plans & pricing', 'ai-growth-suite' ); ?> →</a>
			</div>

			<div class="ags-license-dev">
				<h3><?php esc_html_e( 'Development', 'ai-growth-suite' ); ?></h3>
				<p><?php esc_html_e( 'Local or staging:', 'ai-growth-suite' ); ?></p>
				<div class="ags-license-dev-codes"><code>DEVMODE</code><code>dev</code><code>demo</code></div>
			</div>
		</aside>
	</div>
</div>

<script>
jQuery(function($) {
	$('#ai_growth_suite_deactivate_license').on('click', function() {
		var $btn = $(this);
		if (!confirm('<?php echo esc_js( __( 'Deactivate the license on this site?', 'ai-growth-suite' ) ); ?>')) return;
		$btn.prop('disabled', true);
		$('#ai-license-spinner').css('visibility', 'visible');
		$.post(aiGrowthSuite.ajaxurl, {
			action: 'ai_growth_suite_deactivate_license',
			nonce: $('#ai_growth_suite_license_nonce').val()
		}, function(res) {
			$('#ai-license-spinner').css('visibility', 'hidden');
			$btn.prop('disabled', false);
			if (res.success) { location.reload(); } else { alert(res.data || 'Error'); }
		});
	});
});
</script>
