<?php
global $wpdb;
$currency = function_exists( 'get_woocommerce_currency_symbol' ) ? get_woocommerce_currency_symbol() : '$';
$table_name = $wpdb->prefix . 'dynamic_pricing_rules';

$rules = array();
$active_rules_count = 0;
if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'dynamic_pricing_rules' ) ) {
	$rules = $wpdb->get_results( "SELECT * FROM $table_name" );
	if ( ! is_array( $rules ) ) {
		$rules = array();
	}
	foreach ( $rules as $r ) {
		if ( ! empty( $r->is_active ) ) {
			$active_rules_count++;
		}
	}
}

?>
<div class="ai-growth-suite-dynamic-pricing">
	<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
		<h2>Dynamic Pricing Rules</h2>
		<button class="button button-primary" id="add-new-rule-btn">Create New Rule</button>
	</div>

	<div class="stats-grid" style="grid-template-columns: repeat(2, 1fr);">
		<div class="stat-card">
			<h4>Active Rules</h4>
			<div class="value"><?php echo $active_rules_count; ?></div>
		</div>
		<div class="stat-card">
			<h4>Revenue Impact</h4>
			<div class="value">+<?php echo $currency; ?>0.00</div>
			<p style="color: var(--ai-success); font-size: 0.875rem;">Last 30 days</p>
		</div>
	</div>

	<div class="card" id="create-rule-card" style="display:none; border-left: 4px solid var(--ai-primary);">
		<h3>Create New Rule</h3>
		<form method="post"> <!-- Add action handler later -->
			<input type="hidden" id="ai-rule-id" value="">
			<table class="form-table">
				<tr>
					<th scope="row"><label>Rule Name</label></th>
					<td><input type="text" id="ai-rule-name" class="regular-text" placeholder="e.g. Clearance Sale"></td>
				</tr>
				<tr>
					<th scope="row"><label>Condition</label></th>
					<td>
						<select id="ai-rule-condition">
							<option value="low_inventory">Low Inventory (< 5)</option>
							<option value="time_based">Time Based (Weekend)</option>
							<option value="high_velocity">High Sales Velocity</option>
							<option value="cart_value">Cart Value > <?php echo $currency; ?>100</option>
						</select>
					</td>
				</tr>
				<tr>
					<th scope="row"><label>Action</label></th>
					<td>
						<select id="ai-rule-action-type" style="width: 200px; display: inline-block; margin-right: 10px;">
							<option value="percentage">Decrease Price by %</option>
							<option value="increase_percentage">Increase Price by %</option>
							<option value="fixed">Set Fixed Price</option>
						</select>
						<input type="number" id="ai-rule-amount" class="small-text" placeholder="10" style="width: 80px;">
					</td>
				</tr>
			</table>
			<p class="submit">
				<button type="button" id="ai-save-rule-btn" class="button button-primary">Save Rule</button>
				<button type="button" class="button button-secondary" onclick="document.getElementById('create-rule-card').style.display='none'">Cancel</button>
			</p>
		</form>
	</div>

	<div class="card">
		<h3>Active Rules</h3>
		<table class="widefat fixed striped">
			<thead>
				<tr>
					<th class="manage-column column-primary">Name</th>
					<th>Condition</th>
					<th>Action</th>
					<th>Status</th>
					<th>Actions</th>
				</tr>
			</thead>
			<tbody>
				<?php if ( empty( $rules ) ) : ?>
					<tr><td colspan="5">No rules created yet.</td></tr>
				<?php else : ?>
					<?php foreach ( $rules as $rule ) : 
						$actions = json_decode( $rule->actions, true );
						$action_text = isset($actions['type']) ? $actions['type'] : '';
						?>
						<tr>
							<td class="column-primary"><strong><?php echo esc_html( $rule->rule_name ); ?></strong></td>
							<td><?php echo esc_html( $rule->rule_type ); ?></td> <!-- Simplified -->
							<td><span style="color: var(--ai-danger);"><?php echo esc_html( $action_text ); ?></span></td>
							<td>
								<?php if ( $rule->is_active ) : ?>
									<span class="dashicons dashicons-yes" style="color: var(--ai-success);"></span> Active
								<?php else : ?>
									<span class="dashicons dashicons-no" style="color: var(--ai-text-muted);"></span> Inactive
								<?php endif; ?>
							</td>
							<td>
								<button class="button button-small ai-edit-rule-btn" 
									data-id="<?php echo $rule->id; ?>"
									data-name="<?php echo esc_attr( $rule->rule_name ); ?>"
									data-condition="<?php echo esc_attr( $rule->rule_type ); ?>"
									data-action="<?php echo esc_attr( $actions['type'] ); ?>"
									data-amount="<?php echo esc_attr( $actions['amount'] ); ?>"
								>Edit</button>
								<button class="button button-small button-link-delete ai-delete-rule-btn" data-id="<?php echo $rule->id; ?>" style="color: var(--ai-danger);">Delete</button>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>
		</table>
	</div>
</div>

<script>
document.getElementById('add-new-rule-btn').addEventListener('click', function() {
	document.getElementById('create-rule-card').style.display = 'block';
});
</script>
