<?php
global $wpdb;
$currency = function_exists( 'get_woocommerce_currency_symbol' ) ? get_woocommerce_currency_symbol() : '$';

// Fetch Real Stats (guard if tables don't exist)
$table_carts = $wpdb->prefix . 'abandoned_carts';
$table_tests = $wpdb->prefix . 'ab_tests';
$table_events = $wpdb->prefix . 'ai_events';

$carts_recovered = 0;
$carts_total = 0;
$active_tests = 0;
$revenue = 0;
$recent_activity = array();

if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'abandoned_carts' ) ) {
	$carts_recovered = (int) $wpdb->get_var( "SELECT COUNT(*) FROM $table_carts WHERE status = 'recovered'" );
	$carts_total = (int) $wpdb->get_var( "SELECT COUNT(*) FROM $table_carts" );
	$recent_carts = $wpdb->get_results( "SELECT * FROM $table_carts ORDER BY created_at DESC LIMIT 3" );
	if ( is_array( $recent_carts ) ) {
		foreach ( $recent_carts as $c ) {
			$recent_activity[] = array(
				'event' => 'Abandoned Cart Detected',
				'details' => 'Email: ' . $c->user_email,
				'time' => $c->created_at
			);
		}
	}
}

if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'ab_tests' ) ) {
	$active_tests = (int) $wpdb->get_var( "SELECT COUNT(*) FROM $table_tests WHERE status = 'running'" );
}

if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'ai_events' ) ) {
	$purchase_events = $wpdb->get_results( "SELECT event_data FROM $table_events WHERE event_type = 'purchase'" );
	if ( is_array( $purchase_events ) ) {
		foreach ( $purchase_events as $event ) {
			$data = json_decode( $event->event_data, true );
			if ( isset( $data['total'] ) ) {
				$revenue += floatval( $data['total'] );
			}
		}
	}
}

// Sort recent activity by time
usort( $recent_activity, function( $a, $b ) {
	return strtotime( $b['time'] ) - strtotime( $a['time'] );
});

?>
<div class="ai-growth-suite-dashboard">
	<div class="card" style="background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%); color: white; border: none;">
		<h2 style="color: white; border-bottom: none;">Welcome to AI Growth Suite</h2>
		<p style="font-size: 1.1rem; opacity: 0.9;">Your all-in-one AI-powered eCommerce growth engine is ready to boost your sales.</p>
	</div>
	
	<div class="stats-grid">
		<div class="stat-card">
			<h4>Revenue Generated</h4>
			<div class="value"><?php echo $currency . number_format( $revenue, 2 ); ?></div>
			<p style="color: var(--ai-success); font-size: 0.875rem;">(Tracked via AI Events)</p>
		</div>
		<div class="stat-card">
			<h4>Carts Recovered</h4>
			<div class="value"><?php echo intval( $carts_recovered ); ?></div>
			<p style="color: var(--ai-text-muted); font-size: 0.875rem;">Total: <?php echo intval( $carts_total ); ?></p>
		</div>
		<div class="stat-card">
			<h4>Active A/B Tests</h4>
			<div class="value"><?php echo intval( $active_tests ); ?></div>
			<p style="color: var(--ai-primary); font-size: 0.875rem;">Running Now</p>
		</div>
	</div>

	<div class="card">
		<h3>Recent Activity</h3>
		<table class="widefat">
			<thead>
				<tr>
					<th>Event</th>
					<th>Details</th>
					<th>Time</th>
				</tr>
			</thead>
			<tbody>
				<?php if ( empty( $recent_activity ) ) : ?>
					<tr><td colspan="3">No recent activity found.</td></tr>
				<?php else : ?>
					<?php foreach ( $recent_activity as $activity ) : ?>
						<tr>
							<td><strong><?php echo esc_html( $activity['event'] ); ?></strong></td>
							<td><?php echo esc_html( $activity['details'] ); ?></td>
							<td><?php echo human_time_diff( strtotime( $activity['time'] ), current_time( 'timestamp' ) ) . ' ago'; ?></td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>
		</table>
	</div>
</div>
