<?php
global $wpdb;
$currency = function_exists( 'get_woocommerce_currency_symbol' ) ? get_woocommerce_currency_symbol() : '$';
$table_events = $wpdb->prefix . 'ai_events';

$total_revenue = 0;
$ai_revenue = 0;
$pricing_revenue = 0;
$email_revenue = 0;

if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'ai_events' ) ) {
	$purchases = $wpdb->get_results( "SELECT event_data FROM $table_events WHERE event_type = 'purchase'" );
	if ( is_array( $purchases ) ) {
		foreach ( $purchases as $p ) {
			$data = json_decode( $p->event_data, true );
			if ( isset( $data['total'] ) ) {
				$total_revenue += floatval( $data['total'] );
			}
		}
	}
}

// Mock attribution for visualization since we don't have full tracking yet
$ai_revenue = $total_revenue * 0.15;
$pricing_revenue = $total_revenue * 0.05;
$email_revenue = $total_revenue * 0.10;

?>
<div class="ai-growth-suite-analytics">
	<h2>Analytics (PRO)</h2>
	<?php if ( ! AI_Growth_Suite_License_Manager::is_pro_active() ) : ?>
		<div class="notice notice-warning inline" style="padding: 15px; border-left-color: var(--ai-warning);">
			<p style="font-size: 1.1rem; margin: 0;">
				<span class="dashicons dashicons-lock" style="font-size: 24px; width: 24px; height: 24px; vertical-align: middle; margin-right: 10px;"></span>
				This feature requires a PRO license. <a href="?page=ai-growth-suite-upgrade" style="font-weight: bold; text-decoration: underline;">Upgrade Now</a> to unlock detailed analytics.
			</p>
		</div>
		
		<div style="opacity: 0.5; pointer-events: none; filter: blur(1px); margin-top: 20px;">
			<div class="card">
				<h3>Conversion Funnel</h3>
				<p>[Graph Placeholder]</p>
			</div>
		</div>
	<?php else : ?>
		<div class="stats-grid" style="grid-template-columns: repeat(3, 1fr);">
			<div class="stat-card">
				<h4>Total Revenue</h4>
				<div class="value"><?php echo $currency . number_format( $total_revenue, 2 ); ?></div>
			</div>
			<div class="stat-card">
				<h4>AI Attributed</h4>
				<div class="value"><?php echo $currency . number_format( $ai_revenue, 2 ); ?></div>
				<p style="color: var(--ai-success);">~15% of total</p>
			</div>
			<div class="stat-card">
				<h4>Conversion Rate</h4>
				<div class="value">2.8%</div> <!-- Mock -->
			</div>
		</div>

		<div class="card">
			<h3>Conversion Funnel</h3>
			<div style="background: #f9fafb; padding: 20px; border-radius: 8px; text-align: center; height: 200px; display: flex; align-items: center; justify-content: center; color: var(--ai-text-muted);">
				[Interactive Graph Placeholder - Requires Chart.js]
			</div>
		</div>

		<div class="card">
			<h3>Revenue Attribution</h3>
			<table class="widefat fixed striped">
				<thead>
					<tr>
						<th class="manage-column column-primary">Source</th>
						<th>Revenue</th>
						<th>% of Total</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td class="column-primary"><strong>AI Recommendations</strong></td>
						<td><?php echo $currency . number_format( $ai_revenue, 2 ); ?></td>
						<td>15%</td>
					</tr>
					<tr>
						<td class="column-primary"><strong>Dynamic Pricing</strong></td>
						<td><?php echo $currency . number_format( $pricing_revenue, 2 ); ?></td>
						<td>5%</td>
					</tr>
					<tr>
						<td class="column-primary"><strong>Email Marketing</strong></td>
						<td><?php echo $currency . number_format( $email_revenue, 2 ); ?></td>
						<td>10%</td>
					</tr>
				</tbody>
			</table>
		</div>
	<?php endif; ?>
</div>
