<?php
global $wpdb;
$currency = function_exists( 'get_woocommerce_currency_symbol' ) ? get_woocommerce_currency_symbol() : '$';
$table_name = $wpdb->prefix . 'abandoned_carts';

$carts = array();
$total_abandoned = 0;
$recovered = 0;
$recovery_rate = '0%';
$revenue_recovered = 0.0;
$potential_revenue = 0.0;

if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'abandoned_carts' ) ) {
	$carts = $wpdb->get_results( "SELECT * FROM $table_name ORDER BY created_at DESC LIMIT 50" );
	if ( $carts === null || $carts === false || ! is_array( $carts ) ) {
		$carts = array();
	}
	$total_abandoned = (int) $wpdb->get_var( "SELECT COUNT(*) FROM $table_name WHERE status = 'abandoned'" );
	$recovered = (int) $wpdb->get_var( "SELECT COUNT(*) FROM $table_name WHERE status = 'recovered'" );
	$recovery_rate = ( $total_abandoned + $recovered ) > 0 ? round( ( $recovered / ( $total_abandoned + $recovered ) ) * 100, 1 ) . '%' : '0%';
	$revenue_recovered = (float) $wpdb->get_var( "SELECT SUM(cart_total) FROM $table_name WHERE status = 'recovered'" );
	$potential_revenue = (float) $wpdb->get_var( "SELECT SUM(cart_total) FROM $table_name WHERE status = 'abandoned'" );
}
?>
<div class="ai-growth-suite-abandoned-carts">
	<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
		<div>
			<h2 style="margin: 0;">Abandoned Cart Recovery</h2>
			<p style="color: var(--ai-text-muted); margin: 5px 0 0 0;">Recover lost sales with automated email campaigns</p>
		</div>
		<div>
			<button class="button" id="ai-refresh-carts-btn">
				<span class="dashicons dashicons-update" style="vertical-align: middle;"></span> Refresh
			</button>
		</div>
	</div>

	<div class="stats-grid" style="grid-template-columns: repeat(4, 1fr);">
		<div class="stat-card">
			<h4>Active Abandoned</h4>
			<div class="value" style="color: var(--ai-warning);"><?php echo intval( $total_abandoned ); ?></div>
			<p class="description">Carts waiting for recovery</p>
		</div>
		<div class="stat-card">
			<h4>Recovered</h4>
			<div class="value" style="color: var(--ai-success);"><?php echo intval( $recovered ); ?></div>
			<p class="description">Successfully recovered</p>
		</div>
		<div class="stat-card">
			<h4>Recovery Rate</h4>
			<div class="value"><?php echo $recovery_rate; ?></div>
			<p class="description">Success percentage</p>
		</div>
		<div class="stat-card">
			<h4>Revenue Recovered</h4>
			<div class="value" style="color: var(--ai-success);"><?php echo $currency . number_format( $revenue_recovered, 2 ); ?></div>
			<p class="description">Total recovered value</p>
		</div>
	</div>

	<div class="card">
		<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
			<h3 style="margin: 0;">Recent Abandoned Carts</h3>
			<div style="display: flex; gap: 10px;">
				<input type="text" id="ai-cart-search" placeholder="Search by email..." style="width: 250px;">
				<select id="ai-cart-filter" style="width: 150px;">
					<option value="all">All Status</option>
					<option value="abandoned">Abandoned</option>
					<option value="recovered">Recovered</option>
					<option value="emailed">Email Sent</option>
				</select>
			</div>
		</div>
		
		<table class="widefat fixed striped">
			<thead>
				<tr>
					<th class="manage-column column-primary">Email</th>
					<th>Cart Total</th>
					<th>Items</th>
					<th>Date</th>
					<th>Status</th>
					<th>Actions</th>
				</tr>
			</thead>
			<tbody id="ai-carts-table-body">
				<?php if ( empty( $carts ) ) : ?>
					<tr>
						<td colspan="6" style="text-align: center; padding: 40px; color: var(--ai-text-muted);">
							<span class="dashicons dashicons-cart" style="font-size: 48px; opacity: 0.3;"></span>
							<p style="margin-top: 10px;">No abandoned carts found. Carts will appear here when customers leave items without completing checkout.</p>
						</td>
					</tr>
				<?php else : ?>
					<?php foreach ( $carts as $cart ) : 
						$cart_data = json_decode( $cart->cart_contents, true );
						// Handle different JSON structures
						if (is_array($cart_data)) {
							if (isset($cart_data['items'])) {
								$item_count = count($cart_data['items']);
							} else {
								$item_count = count($cart_data);
							}
						} else {
							$item_count = 0;
						}
					?>
						<tr class="ai-cart-row" data-email="<?php echo esc_attr( $cart->user_email ); ?>" data-status="<?php echo esc_attr( $cart->status ); ?>">
							<td class="column-primary">
								<strong><?php echo esc_html( $cart->user_email ); ?></strong>
							</td>
							<td><strong><?php echo $currency . number_format( $cart->cart_total, 2 ); ?></strong></td>
							<td><?php echo $item_count; ?> item<?php echo $item_count != 1 ? 's' : ''; ?></td>
							<td><?php echo human_time_diff( strtotime( $cart->created_at ), current_time( 'timestamp' ) ) . ' ago'; ?></td>
							<td>
								<?php if ( $cart->status === 'recovered' ) : ?>
									<span class="dashicons dashicons-yes" style="color: var(--ai-success);"></span> Recovered
								<?php elseif ( $cart->status === 'abandoned' ) : ?>
									<span class="dashicons dashicons-clock" style="color: var(--ai-warning);"></span> Abandoned
								<?php else : ?>
									<span class="dashicons dashicons-email-alt" style="color: var(--ai-primary);"></span> <?php echo ucfirst( $cart->status ); ?>
								<?php endif; ?>
							</td>
							<td>
								<button class="button button-small ai-view-cart-btn" data-id="<?php echo $cart->id; ?>" data-email="<?php echo esc_attr( $cart->user_email ); ?>" data-total="<?php echo $cart->cart_total; ?>" data-items='<?php echo esc_attr( $cart->cart_contents ); ?>' data-date="<?php echo $cart->created_at; ?>" data-status="<?php echo $cart->status; ?>">View Details</button>
								<?php if ( $cart->status === 'abandoned' ) : ?>
								<button class="button button-small button-primary ai-send-recovery-btn" data-id="<?php echo $cart->id; ?>" data-email="<?php echo esc_attr( $cart->user_email ); ?>">Send Email</button>
								<?php endif; ?>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>
		</table>
	</div>
</div>

<!-- Cart Details Modal -->
<div id="ai-cart-details-modal" style="display:none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999; align-items: center; justify-content: center;">
	<div style="background: #fff; border-radius: 8px; width: 600px; max-width: 90%; max-height: 90vh; box-shadow: 0 4px 20px rgba(0,0,0,0.15); display: flex; flex-direction: column;">
		<!-- Modal Header -->
		<div style="padding: 20px 30px; border-bottom: 1px solid #ddd;">
			<h3 style="margin: 0;">Cart Details</h3>
		</div>

		<!-- Modal Body (Scrollable) -->
		<div style="padding: 20px 30px; overflow-y: auto; flex: 1;">
			<div style="margin-bottom: 20px;">
				<p style="margin: 0 0 10px 0;"><strong>Customer Email:</strong> <span id="ai-cart-email"></span></p>
				<p style="margin: 0 0 10px 0;"><strong>Cart Total:</strong> <span id="ai-cart-total"></span></p>
				<p style="margin: 0 0 10px 0;"><strong>Abandoned:</strong> <span id="ai-cart-date"></span></p>
				<p style="margin: 0;"><strong>Status:</strong> <span id="ai-cart-status"></span></p>
			</div>

			<h4 style="margin: 20px 0 10px 0; padding-bottom: 10px; border-bottom: 2px solid #ddd;">Cart Items</h4>
			<div id="ai-cart-items" style="background: #f7f7f7; padding: 15px; border-radius: 5px;">
				<!-- Items will be loaded here -->
			</div>
		</div>

		<!-- Modal Footer (Fixed) -->
		<div style="padding: 20px 30px; border-top: 2px solid #ddd; background: #fff; text-align: right; flex-shrink: 0;">
			<button type="button" class="button button-secondary" onclick="document.getElementById('ai-cart-details-modal').style.display='none'" style="margin-right: 10px;">Close</button>
			<button type="button" id="ai-modal-send-recovery-btn" class="button button-primary" style="min-width: 120px;">📧 Send Recovery Email</button>
		</div>
	</div>
</div>
