<?php
global $wpdb;
$currency = function_exists( 'get_woocommerce_currency_symbol' ) ? get_woocommerce_currency_symbol() : '$';
$table_tests = $wpdb->prefix . 'ab_tests';

$tests = array();
$active_tests = 0;

if ( function_exists( 'ai_growth_suite_table_exists' ) && ai_growth_suite_table_exists( 'ab_tests' ) ) {
	$tests = $wpdb->get_results( "SELECT * FROM $table_tests ORDER BY start_date DESC" );
	if ( $tests === null || $tests === false || ! is_array( $tests ) ) {
		$tests = array();
	}
	foreach ( $tests as $t ) {
		if ( $t->status === 'running' ) {
			$active_tests++;
		}
	}
}

?>
<div class="ai-growth-suite-ab-testing">
	<h2>A/B Testing (PRO)</h2>
	<?php if ( ! ( class_exists( 'AI_Growth_Suite_License_Manager' ) && AI_Growth_Suite_License_Manager::is_pro_active() ) ) : ?>
		<div class="notice notice-warning inline" style="padding: 15px; border-left-color: var(--ai-warning);">
			<p style="font-size: 1.1rem; margin: 0;">
				<span class="dashicons dashicons-lock" style="font-size: 24px; width: 24px; height: 24px; vertical-align: middle; margin-right: 10px;"></span>
				This feature requires a PRO license. <a href="?page=ai-growth-suite-upgrade" style="font-weight: bold; text-decoration: underline;">Upgrade Now</a> to unlock powerful A/B testing capabilities.
			</p>
		</div>
		
		<div style="opacity: 0.5; pointer-events: none; filter: blur(1px); margin-top: 20px;">
			<div class="stats-grid">
				<div class="stat-card">
					<h4>Active Tests</h4>
					<div class="value">0</div>
				</div>
				<div class="stat-card">
					<h4>Winning Variants</h4>
					<div class="value">0</div>
				</div>
			</div>
			<div class="card">
				<h3>Running Tests</h3>
				<p>No active tests found.</p>
			</div>
		</div>
	<?php else : ?>
		<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
			<p>Test different product content to maximize conversions.</p>
			<button class="button button-primary">Create New Test</button>
		</div>

		<div class="stats-grid">
			<div class="stat-card">
				<h4>Active Tests</h4>
				<div class="value"><?php echo intval( $active_tests ); ?></div>
			</div>
			<div class="stat-card">
				<h4>Avg. Conversion Lift</h4>
				<div class="value">+0%</div> <!-- Mock for now -->
			</div>
		</div>

		<div class="card">
			<h3>Running Tests</h3>
			<table class="widefat fixed striped">
				<thead>
					<tr>
						<th class="manage-column column-primary">Test Name</th>
						<th>Product</th>
						<th>Traffic Split</th>
						<th>Status</th>
						<th>Actions</th>
					</tr>
				</thead>
				<tbody>
					<?php if ( empty( $tests ) ) : ?>
						<tr><td colspan="5">No A/B tests found.</td></tr>
					<?php else : ?>
						<?php foreach ( $tests as $test ) : 
							$product = wc_get_product( $test->product_id );
							?>
							<tr>
								<td class="column-primary"><strong><?php echo esc_html( $test->test_type ); ?></strong></td>
								<td><?php echo $product ? $product->get_name() : 'Unknown Product'; ?></td>
								<td><?php echo esc_html( $test->traffic_split ); ?>/<?php echo 100 - intval( $test->traffic_split ); ?></td>
								<td>
									<?php if ( $test->status === 'running' ) : ?>
										<span class="dashicons dashicons-chart-line" style="color: var(--ai-success);"></span> Running
									<?php else : ?>
										<span class="dashicons dashicons-flag" style="color: var(--ai-text-muted);"></span> <?php echo ucfirst( $test->status ); ?>
									<?php endif; ?>
								</td>
								<td><button class="button button-small" data-test-id="<?php echo (int) $test->id; ?>" data-product-name="<?php echo esc_attr( $product ? $product->get_name() : '' ); ?>" data-test-type="<?php echo esc_attr( $test->test_type ); ?>">View Report</button></td>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>
				</tbody>
			</table>
		</div>
	<?php endif; ?>
</div>
