<?php
// Simple direct insert - GUARANTEED TO WORK
require_once('../../../wp-load.php');

global $wpdb;

// Get table name
$table = $wpdb->prefix . 'abandoned_carts';

echo "<h1>Inserting Data into: $table</h1>";

// Delete all existing data
$wpdb->query("DELETE FROM $table");
echo "<p>✓ Cleared table</p>";

// Insert 5 carts one by one
$cart1 = $wpdb->query($wpdb->prepare(
    "INSERT INTO $table (user_email, cart_contents, cart_total, status, created_at) 
     VALUES (%s, %s, %f, %s, %s)",
    'john.doe@example.com',
    '{"items":[{"name":"Headphones","quantity":1,"price":79.99}]}',
    79.99,
    'abandoned',
    date('Y-m-d H:i:s', strtotime('-3 hours'))
));
echo $cart1 ? "<p style='color:green'>✓ Cart 1 inserted</p>" : "<p style='color:red'>✗ Cart 1 failed: " . $wpdb->last_error . "</p>";

$cart2 = $wpdb->query($wpdb->prepare(
    "INSERT INTO $table (user_email, cart_contents, cart_total, status, created_at) 
     VALUES (%s, %s, %f, %s, %s)",
    'jane.smith@example.com',
    '{"items":[{"name":"Laptop Stand","quantity":1,"price":49.99}]}',
    49.99,
    'abandoned',
    date('Y-m-d H:i:s', strtotime('-1 day'))
));
echo $cart2 ? "<p style='color:green'>✓ Cart 2 inserted</p>" : "<p style='color:red'>✗ Cart 2 failed: " . $wpdb->last_error . "</p>";

$cart3 = $wpdb->query($wpdb->prepare(
    "INSERT INTO $table (user_email, cart_contents, cart_total, status, created_at) 
     VALUES (%s, %s, %f, %s, %s)",
    'bob.wilson@example.com',
    '{"items":[{"name":"Mouse","quantity":2,"price":15.99}]}',
    31.98,
    'emailed',
    date('Y-m-d H:i:s', strtotime('-2 days'))
));
echo $cart3 ? "<p style='color:green'>✓ Cart 3 inserted</p>" : "<p style='color:red'>✗ Cart 3 failed: " . $wpdb->last_error . "</p>";

$cart4 = $wpdb->query($wpdb->prepare(
    "INSERT INTO $table (user_email, cart_contents, cart_total, status, created_at) 
     VALUES (%s, %s, %f, %s, %s)",
    'alice.johnson@example.com',
    '{"items":[{"name":"Keyboard","quantity":1,"price":89.99}]}',
    89.99,
    'recovered',
    date('Y-m-d H:i:s', strtotime('-5 days'))
));
echo $cart4 ? "<p style='color:green'>✓ Cart 4 inserted</p>" : "<p style='color:red'>✗ Cart 4 failed: " . $wpdb->last_error . "</p>";

$cart5 = $wpdb->query($wpdb->prepare(
    "INSERT INTO $table (user_email, cart_contents, cart_total, status, created_at) 
     VALUES (%s, %s, %f, %s, %s)",
    'mike.brown@example.com',
    '{"items":[{"name":"Monitor","quantity":1,"price":299.99}]}',
    299.99,
    'abandoned',
    date('Y-m-d H:i:s', strtotime('-6 hours'))
));
echo $cart5 ? "<p style='color:green'>✓ Cart 5 inserted</p>" : "<p style='color:red'>✗ Cart 5 failed: " . $wpdb->last_error . "</p>";

// Verify
$count = $wpdb->get_var("SELECT COUNT(*) FROM $table");
echo "<hr>";
echo "<h2>Verification</h2>";
echo "<p><strong>Total rows:</strong> $count</p>";

if ($count > 0) {
    $rows = $wpdb->get_results("SELECT * FROM $table");
    echo "<table border='1' cellpadding='10' style='border-collapse:collapse; width:100%;'>";
    echo "<tr style='background:#333;color:white'><th>ID</th><th>Email</th><th>Total</th><th>Status</th><th>Created</th></tr>";
    foreach ($rows as $row) {
        echo "<tr>";
        echo "<td>$row->id</td>";
        echo "<td>$row->user_email</td>";
        echo "<td>\$$row->cart_total</td>";
        echo "<td><strong>$row->status</strong></td>";
        echo "<td>$row->created_at</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<hr>";
    echo "<div style='background:#d4edda;padding:20px;margin:20px 0;border-radius:5px;'>";
    echo "<h2 style='color:#155724;margin:0 0 10px 0'>✓ SUCCESS!</h2>";
    echo "<p style='color:#155724;font-size:18px'>$count carts inserted successfully!</p>";
    echo "<a href='" . admin_url('admin.php?page=ai-growth-suite-abandoned-carts') . "' style='display:inline-block;background:#28a745;color:white;padding:15px 30px;text-decoration:none;border-radius:5px;font-weight:bold;margin-top:10px'>→ GO TO ABANDONED CARTS PAGE</a>";
    echo "</div>";
} else {
    echo "<p style='color:red;font-size:20px'><strong>ERROR: No data inserted!</strong></p>";
}
?>
