# AI eCommerce Growth Suite – Features

All-in-one AI-powered eCommerce growth plugin for WooCommerce: product descriptions, upsells, dynamic pricing, abandoned cart recovery, A/B testing, analytics, and marketing automation.

---

## Requirements

- **WordPress** 5.8+
- **PHP** 7.4+
- **WooCommerce** (active)

---

## Free vs PRO

| Feature | Free | PRO |
|--------|------|-----|
| Basic Product Descriptions | Yes | Yes |
| Standard Upsells | Yes | Yes |
| A/B Testing (titles & descriptions) | No | Yes |
| Advanced Analytics dashboard | No | Yes |
| Unlimited AI content generation | No | Yes |
| Automatic plugin updates | No | Yes |
| Priority email support | No | Yes |

PRO status is determined by **License & Activation** (`AI Growth Suite → License`).  
Dev keys `DEVMODE`, `dev`, `demo`, `localhost` activate PRO for local/staging.

---

## 1. Dashboard

**Path:** `AI Growth Suite → Dashboard`

- Overview of abandoned carts, A/B tests, and analytics (when tables exist).
- Links to main sections.

---

## 2. Product AI Tools (Free)

**Path:** `AI Growth Suite → Product AI Tools`

- **Bulk generator**
  - Table of products with pagination and category filter.
  - **Generate** / **Regenerate** per product: calls AI (OpenAI) to create SEO-oriented description and short description; saves to product and sets `_ai_optimized`, `_ai_last_optimized`.
- **Generate All Descriptions**
  - Runs generate for all products on the current page via REST `generate-description`.
- **Requirement:** `Settings → AI API Key` (OpenAI).

---

## 3. Upsell & Cross-Sell (Free)

**Path:** `AI Growth Suite → Upsell & Cross-Sell`

- **Active suggestions**
  - Table of product recommendations from `ai_recommendations` (product_id → JSON of related product IDs).
- **Force Regenerate All**
  - Fetches all products via `get-all-products`, then runs `generate-upsells` per product; uses `AI_Engine::generate_recommendations()` (category-based, no external AI) and saves to `ai_recommendations`.
- **Edit** – opens product in WooCommerce.
- **Disable** – deletes the row in `ai_recommendations`.
- **Search** – client-side filter by product name.
- **Frontend:** “You may also like” block on single product pages via `templates/recommendations.php` (only when `ai_recommendations` has data for that product).

---

## 4. Dynamic Pricing

**Path:** `AI Growth Suite → Dynamic Pricing`

- **Settings:** Master switch **Enable Dynamic Pricing Globally** in `AI Growth Suite → Settings`. If off, no rules or product-level overrides are applied.
- **Create / Edit rules**
  - Name, condition, action, amount.
  - **Conditions:** Low inventory (&lt;5), Time based (weekend), High sales velocity, Cart value &gt; $100.
  - **Actions:** Decrease by %, Increase by %, Set fixed price.
- **Product-level overrides** (WooCommerce product edit sidebar, “AI Growth Suite – Dynamic Pricing”):
  - Enable custom rule, Action (same as above), Amount.
- **Application:** `woocommerce_product_get_price` and `woocommerce_product_variation_get_price`; product-level rules override global rules. Table `dynamic_pricing_rules` must exist.

---

## 5. Marketing Automation

**Path:** `AI Growth Suite → Marketing`

### Tabs

- **Email Flows**
  - List from `email_flows` plus built-in placeholders (Welcome, Post-Purchase, Win-Back) if DB is empty.
  - **Create New Flow** – name, trigger, AI tone; saved via `create-flow`.
  - **Edit Template** – subject, body, auto-send, send timing (immediate, delay, specific time); uses `get-email-template` and `save-email-template`.
  - **Toggle** – enable/disable flow via `toggle-flow-status`.
  - **Delete** – `delete-flow` (only for DB-backed flows).
- **Email Log**
  - Counts and list from `ai_email_log` (sent/failed).
- **Settings**
  - **Brand Tone** (Professional, Friendly, Humorous, Luxury) – stored in `ai_growth_suite_brand_tone`; used by AI for email content.

Templates support tokens: `{name}`, `{email}`, `{store_name}`, `{store_url}`, `{order_number}`, `{order_date}`, `{order_total}`, `{order_items}`, `{order_url}`, `{product_name}`, `{product_url}`, `{shipping_address}`, `{tracking_url}`, `{support_email}`, `{unsubscribe_url}`, etc.

---

## 6. Abandoned Cart Recovery

**Path:** `AI Growth Suite → Abandoned Carts`

- **Data source:** `Abandoned_Cart` class on `woocommerce_checkout_update_order_review` (when billing email is present). Saves/updates `abandoned_carts` (user_email, cart_contents JSON, cart_total, status).
- **Recovery on order:** `woocommerce_new_order` marks rows for that email as `recovered` and sets `recovered_at`.
- **Cron:** `ai_growth_suite_abandoned_cart_cron` (every 15 minutes); `send_recovery_emails` finds abandoned carts older than 1 hour. Sending logic in the class is stubbed; actual sending is done via:
  - **Send Recovery** in admin: REST `send-recovery-email` uses `ai_growth_suite_template_abandoned_cart` and `wp_mail`, then sets status to `emailed` and logs to `ai_email_log`.
- **UI:** Stats (active, recovered, recovery rate, revenue recovered), table with View and Send Recovery. **View** opens a modal with cart items (supports different JSON shapes: `items` array or plain array). **Refresh** reloads the page.

---

## 7. A/B Testing (PRO)

**Path:** `AI Growth Suite → A/B Testing (PRO)`

- **Gating:** Full UI and frontend behavior only when `AI_Growth_Suite_License_Manager::is_pro_active()` is true. Otherwise a lock message and blurred placeholder are shown.
- **Create New Test**
  - Product (from `get-all-products`), test type (title, description, price, image), traffic split, Variant A (optional, else from product), Variant B (required). Stored in `ab_tests`; variant_b as `{ "type": "{{test_type}}", "content": "..." }`.
- **Frontend (PRO only):**
  - `assign_variant` sets cookie `ai_ab_variant` (A/B) on product pages.
  - `filter_title`: if test type is `title` and variant B, shows `content` from `variant_b`.
  - `filter_description`: if test type is `description` and variant B, shows `content` from `variant_b`.
  - **Note:** `price` and `image` tests are stored but not applied on the frontend.
- **View Report** – modal with mock stats (no backend yet).

---

## 8. Analytics (PRO)

**Path:** `AI Growth Suite → Analytics (PRO)`

- **Gating:** Same as A/B Testing; full dashboard only when PRO.
- **Tracking (PRO only):**
  - `track_page_view` – product views → `ai_events` (`product_view`).
  - `track_add_to_cart` – `add_to_cart` with product_id, quantity.
  - `track_purchase` – on `woocommerce_thankyou`, `purchase` with order_id and total.
- **Dashboard:** Total revenue from `purchase` events, AI / pricing / email attribution (mocked), conversion rate (mocked), and placeholder for a conversion funnel graph.

---

## 9. Settings

**Path:** `AI Growth Suite → Settings`

- **AI API Key** – OpenAI key for Product AI; `ai_growth_suite_api_key`.
- **Enable Dynamic Pricing Globally** – `ai_growth_suite_dynamic_pricing_enabled` (0/1). Checkbox is correctly saved when unchecked via a hidden `0` and sanitization.
- Form posts to `options.php`; custom option group is whitelisted via `whitelist_options`. Success redirect shows “Settings saved.”

---

## 10. License & Activation

**Path:** `AI Growth Suite → License`

- **Status:** “License Active” only when `ai_growth_suite_license_status === 'valid'` **and** `ai_growth_suite_license_key_hash` is not empty. `verify_license` on `admin_init` clears invalid state (e.g. `valid` with no hash).
- **Activate:** Sends key to `ai_growth_suite_activate_license` (AJAX). Accepts dev keys or your license API (`ai_growth_suite_license_api_url`). On success, stores hash, status, plan, etc.
- **Deactivate:** AJAX `ai_growth_suite_deactivate_license`; clears hash, sets status to `invalid`, and related options.
- **Sidebar:** “Included in Free” (Basic Product Descriptions, Standard Upsells) and “Included in PRO” (A/B Testing, Advanced Analytics, Unlimited AI, Automatic updates, Priority support). Development keys: `DEVMODE`, `dev`, `demo`.

---

## 11. Upgrade to PRO

**Path:** `AI Growth Suite → Upgrade to PRO`

- Free and PRO plan cards and feature lists aligned with License page. No license form here; activation is only on the License page.

---

## REST API (`/wp-json/ai-growth-suite/v1/`)

All require `manage_options`. Nonce: `X-WP-Nonce` (from `wp_create_nonce('wp_rest')`).

| Endpoint | Method | Purpose |
|----------|--------|---------|
| `/generate-description` | POST | product_id → AI description/short_description, save to product |
| `/generate-upsells` | POST | product_id → generate and save recommendations |
| `/get-all-products` | GET | list of `{ id, name }` |
| `/delete-recommendation` | POST | product_id → delete from `ai_recommendations` |
| `/analytics` | GET | mock analytics (views, conversions, revenue) |
| `/create-rule` | POST | create/update dynamic pricing rule (id, name, condition_type, action_type, amount) |
| `/delete-rule` | POST | rule_id → delete rule |
| `/save-marketing-settings` | POST | tone → `ai_growth_suite_brand_tone` |
| `/get-email-template` | GET | flow → subject, body, automation fields |
| `/save-email-template` | POST | flow, subject, body, auto_send, send_timing, delay_amount, specific_time |
| `/create-flow` | POST | name, trigger, tone → `email_flows` |
| `/delete-flow` | POST | flow_id |
| `/toggle-flow-status` | POST | flow_id, is_active |
| `/send-recovery-email` | POST | cart_id → send abandoned cart email, update status, log |
| `/create-ab-test` | POST | product_id, test_type, variant_a, variant_b, traffic_split → `ab_tests` |

---

## Database Tables

Created on plugin activation (`create_tables`); `maybe_create_tables` on `plugins_loaded` ensures `abandoned_carts`, `ab_tests`, `ai_events` if missing.

- `{prefix}ai_recommendations` – product_id, recommendations (JSON), generated_at  
- `{prefix}dynamic_pricing_rules` – rule_name, rule_type, conditions, actions, is_active  
- `{prefix}abandoned_carts` – user_email, cart_contents, cart_total, created_at, status, recovered_at  
- `{prefix}ai_email_log` – email_to, subject, type, sent_at, status  
- `{prefix}ab_tests` – product_id, test_type, variant_a, variant_b, traffic_split, start_date, end_date, status  
- `{prefix}ai_events` – event_type, event_data, created_at, user_id  
- `{prefix}email_flows` – flow_name, flow_slug, trigger_type, ai_tone, is_active, created_at  
- `{prefix}ai_licenses` – (reserved for license server use)

---

## Cron

- `ai_growth_suite_cron_event` (hourly) – used by `Recommendation_Engine::regenerate_recommendations` (up to 10 random products).
- `ai_growth_suite_abandoned_cart_cron` (every 15 minutes) – `Abandoned_Cart::send_recovery_emails` (logic is stubbed; manual send via REST works).

---

## Other Files

- **`includes/class-cart-tracker.php`** – Cart tracking on add/remove/update and `ai_growth_suite_check_abandoned_carts` cron. **Not loaded** by the main plugin; `Abandoned_Cart` is used instead.
- **`includes/class-email-engine.php`** – Email utilities; used by flows and recovery where applicable.
- **`ai-growth-suite.php`** – Boot, `create_tables`, `maybe_create_tables`, cron schedules, `ai_growth_suite_table_exists()`, and requirement checks (PHP 7.4+, WooCommerce).

---

## Fixes Applied (Summary)

- **License:** `is_pro_active()` requires both `valid` and non‑empty `license_key_hash`; `verify_license` fixes inconsistent “valid without hash” state.
- **Settings:** `whitelist_options` for custom group; sanitize for API key and dynamic-pricing checkbox; hidden `0` for unchecked checkbox; “Settings saved” notice.
- **A/B Testing:** `filter_title` / `filter_description` use `variant_b.content` and `test_type` (title/description); PRO-gated in main plugin init.
- **Analytics:** PRO-gated in main plugin init.
- **Dynamic pricing:** Respects `ai_growth_suite_dynamic_pricing_enabled`; when disabled, all rules and product overrides are skipped.

---

## Optional / Not in Main Flow

- **Cart tracker** – Implemented but not required by the main plugin; abandoned carts are captured via `Abandoned_Cart` and `woocommerce_checkout_update_order_review`.
- **Bulk actions** on Product AI (Generate/Regenerate via form submit) – UI exists; server-side handling of `product_ids[]` and `action` is not implemented; per-product Generate and “Generate All Descriptions” work.
- **A/B tests for price and image** – Stored; no frontend filters.
- **Abandoned cart cron sending** – Placeholder; manual “Send Recovery” in admin is fully functional.
